/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import com.simonharrer.modernizer.ModernizerPluginExtension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gaul.modernizer_maven_plugin.Modernizer;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.gradle.api.logging.Logger;

public class ModernizerWrapper {
    public static final String MODERNIZER_VIOLATIONS_FILE = "modernizer.violationsFile";

    public static void execute(ModernizerPluginExtension extension, Path classesDir, List<Path> sourceDirs, Logger logger) throws Exception {
        List foundViolations;
        Modernizer modernizer = ModernizerWrapper.getModernizer(extension);
        try (Stream<Path> walk = Files.walk(classesDir, new FileVisitOption[0]);){
            foundViolations = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".class")).flatMap(p -> {
                try {
                    InputStream is = Files.newInputStream(p, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        Stream<ViolationOccurrence> stream = modernizer.check(is).stream().peek(v -> {
                            Path sourcePath = ModernizerWrapper.sourceFileName(p, classesDir, sourceDirs);
                            String message = String.format("%s:%d: %s", sourcePath.toString(), v.getLineNumber(), v.getViolation().getComment());
                            logger.warn(message);
                        });
                        return stream;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is != null) {
                            ModernizerWrapper.$closeResource(throwable, is);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        if (!foundViolations.isEmpty() && extension.isFailOnViolations()) {
            throw new Exception("Found " + foundViolations.size() + " violations");
        }
    }

    private static Modernizer getModernizer(ModernizerPluginExtension extension) throws Exception {
        return new Modernizer(extension.getJavaVersion(), ModernizerWrapper.getConfiguredViolations(extension.getViolationsFile()), ModernizerWrapper.getExclusions(extension.getExclusionsFile()), ModernizerWrapper.getExclusionPatterns(extension.getExclusionPatterns()), extension.getIgnorePackages());
    }

    private static Set<String> getExclusions(String exclusionsFile) throws Exception {
        HashSet<String> exclusions = new HashSet<String>();
        if (exclusionsFile != null && !exclusionsFile.trim().isEmpty()) {
            Path path = Paths.get(exclusionsFile, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    exclusions.addAll(Files.readAllLines(path));
                }
                catch (IOException ioe) {
                    throw new Exception("Error reading exclusion file: " + path, ioe);
                }
            }
            try (InputStream inputStream = ModernizerWrapper.class.getResourceAsStream(exclusionsFile);){
                if (inputStream == null) {
                    throw new Exception("Could not find exclusion file in classpath: " + exclusionsFile);
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        exclusions.add(line);
                    }
                }
            }
            catch (IOException ioe) {
                throw new Exception("Error reading exclusion file in classpath: " + exclusionsFile, ioe);
            }
        }
        return exclusions;
    }

    private static Path sourceFileName(Path name, Path outputDir, List<Path> sourcesDirs) {
        if (name.startsWith(outputDir)) {
            for (Path sourceDir : sourcesDirs) {
                Path newname = sourceDir.resolve(name.toString().substring(outputDir.toString().length()));
                if (!Files.exists(newname = newname.getParent().resolve(newname.getFileName().toString().replace(".class", ".java")), new LinkOption[0])) continue;
                return newname;
            }
        }
        return name;
    }

    private static Map<String, Violation> getConfiguredViolations(String violationsFile) throws Exception {
        Map violations;
        block27: {
            if (violationsFile != null && !violationsFile.trim().isEmpty()) {
                Path path = Paths.get(violationsFile, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                        violations = Modernizer.parseFromXml((InputStream)inputStream);
                        break block27;
                    }
                    catch (IOException e) {
                        throw new Exception("Could not read modernizer.violationsFile = " + violationsFile);
                    }
                }
                try (InputStream inputStream = ModernizerWrapper.class.getResourceAsStream(violationsFile);){
                    if (inputStream == null) {
                        throw new Exception("Could not find modernizer.violationsFile in classpath: " + violationsFile);
                    }
                    violations = Modernizer.parseFromXml((InputStream)inputStream);
                    break block27;
                }
                catch (IOException ioe) {
                    throw new Exception("Error reading modernizer.violationsFile in classpath: " + violationsFile, ioe);
                }
            }
            try (InputStream inputStream = ModernizerWrapper.class.getResourceAsStream("/modernizer.xml");){
                violations = Modernizer.parseFromXml((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new Exception("Could not read modernizer.violationsFile = /modernizer.xml");
            }
        }
        return violations;
    }

    private static Collection<Pattern> getExclusionPatterns(Collection<String> exclusionPatterns) throws PatternSyntaxException {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(exclusionPatterns.size());
        for (String exclusionPattern : exclusionPatterns) {
            patterns.add(Pattern.compile(exclusionPattern));
        }
        return patterns;
    }
}

