/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.gradle.task;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.gradle.FlywayExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractFlywayTask
extends DefaultTask {
    protected FlywayExtension extension;
    public String driver;
    public String url;
    public String user;
    public String password;
    public String table;
    public String[] schemas;
    public String baselineVersion;
    public String baselineDescription;
    public String[] locations;
    public String[] resolvers;
    public Boolean skipDefaultResolvers;
    public String sqlMigrationPrefix;
    public String undoSqlMigrationPrefix;
    public String repeatableSqlMigrationPrefix;
    public String sqlMigrationSeparator;
    @Deprecated
    public String sqlMigrationSuffix;
    public String[] sqlMigrationSuffixes;
    public String encoding;
    public Map<Object, Object> placeholders;
    public Boolean placeholderReplacement;
    public String placeholderPrefix;
    public String placeholderSuffix;
    public String target;
    public String[] callbacks;
    public Boolean skipDefaultCallbacks;
    public Boolean outOfOrder;
    public Boolean validateOnMigrate;
    public Boolean cleanOnValidationError;
    public Boolean ignoreMissingMigrations;
    public Boolean ignoreFutureMigrations;
    public Boolean cleanDisabled;
    public Boolean baselineOnMigrate;
    public Boolean mixed;
    public Boolean group;
    public String installedBy;
    public String[] errorHandlers;
    public String dryRunOutput;
    public String configFileEncoding;
    public String[] configFiles;

    public AbstractFlywayTask() {
        this.setGroup("Flyway");
        this.extension = (FlywayExtension)this.getProject().getExtensions().getByName("flyway");
    }

    @TaskAction
    public Object runTask() {
        try {
            ArrayList<URL> extraURLs = new ArrayList<URL>();
            if (this.isJavaProject()) {
                JavaPluginConvention plugin = (JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class);
                for (SourceSet sourceSet : plugin.getSourceSets()) {
                    try {
                        Method getClassesDirs = SourceSetOutput.class.getMethod("getClassesDirs", new Class[0]);
                        FileCollection classesDirs = (FileCollection)getClassesDirs.invoke((Object)sourceSet.getOutput(), new Object[0]);
                        for (File directory : classesDirs.getFiles()) {
                            URL classesUrl = directory.toURI().toURL();
                            this.getLogger().debug("Adding directory to Classpath: " + classesUrl);
                            extraURLs.add(classesUrl);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        URL classesUrl = sourceSet.getOutput().getClassesDir().toURI().toURL();
                        this.getLogger().debug("Adding directory to Classpath: " + classesUrl);
                        extraURLs.add(classesUrl);
                    }
                    URL resourcesUrl = sourceSet.getOutput().getResourcesDir().toURI().toURL();
                    this.getLogger().debug("Adding directory to Classpath: " + resourcesUrl);
                    extraURLs.add(resourcesUrl);
                }
                this.addDependenciesWithScope(extraURLs, "compile");
                this.addDependenciesWithScope(extraURLs, "runtime");
                this.addDependenciesWithScope(extraURLs, "testCompile");
                this.addDependenciesWithScope(extraURLs, "testRuntime");
            }
            URLClassLoader classLoader = new URLClassLoader(extraURLs.toArray(new URL[extraURLs.size()]), this.getProject().getBuildscript().getClassLoader());
            Flyway flyway = new Flyway((ClassLoader)classLoader);
            flyway.configure(this.createFlywayConfig());
            return this.run(flyway);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void addDependenciesWithScope(List<URL> urls, String scope) throws IOException {
        for (ResolvedArtifact artifact : this.getProject().getConfigurations().getByName(scope).getResolvedConfiguration().getResolvedArtifacts()) {
            URL artifactUrl = artifact.getFile().toURI().toURL();
            this.getLogger().debug("Adding Dependency to Classpath: " + artifactUrl);
            urls.add(artifactUrl);
        }
    }

    protected abstract Object run(Flyway var1);

    private Map<String, String> createFlywayConfig() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("flyway.locations", "filesystem:" + this.getProject().getProjectDir().getAbsolutePath() + "/src/main/resources/db/migration");
        Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
        AbstractFlywayTask.addConfigFromProperties(conf, this.loadConfigurationFromDefaultConfigFiles(envVars));
        ConfigUtils.putIfSet(conf, (String)"flyway.driver", (Object[])new Object[]{this.driver, this.extension.driver});
        ConfigUtils.putIfSet(conf, (String)"flyway.url", (Object[])new Object[]{this.url, this.extension.url});
        ConfigUtils.putIfSet(conf, (String)"flyway.user", (Object[])new Object[]{this.user, this.extension.user});
        ConfigUtils.putIfSet(conf, (String)"flyway.password", (Object[])new Object[]{this.password, this.extension.password});
        ConfigUtils.putIfSet(conf, (String)"flyway.table", (Object[])new Object[]{this.table, this.extension.table});
        ConfigUtils.putIfSet(conf, (String)"flyway.baselineVersion", (Object[])new Object[]{this.baselineVersion, this.extension.baselineVersion});
        ConfigUtils.putIfSet(conf, (String)"flyway.baselineDescription", (Object[])new Object[]{this.baselineDescription, this.extension.baselineDescription});
        ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationPrefix", (Object[])new Object[]{this.sqlMigrationPrefix, this.extension.sqlMigrationPrefix});
        ConfigUtils.putIfSet(conf, (String)"flyway.undoSqlMigrationPrefix", (Object[])new Object[]{this.undoSqlMigrationPrefix, this.extension.undoSqlMigrationPrefix});
        ConfigUtils.putIfSet(conf, (String)"flyway.repeatableSqlMigrationPrefix", (Object[])new Object[]{this.repeatableSqlMigrationPrefix, this.extension.repeatableSqlMigrationPrefix});
        ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationSeparator", (Object[])new Object[]{this.sqlMigrationSeparator, this.extension.sqlMigrationSeparator});
        ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationSuffix", (Object[])new Object[]{this.sqlMigrationSuffix, this.extension.sqlMigrationSuffix});
        ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationSuffixes", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.sqlMigrationSuffixes), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.sqlMigrationSuffixes)});
        ConfigUtils.putIfSet(conf, (String)"flyway.mixed", (Object[])new Object[]{this.mixed, this.extension.mixed});
        ConfigUtils.putIfSet(conf, (String)"flyway.group", (Object[])new Object[]{this.group, this.extension.group});
        ConfigUtils.putIfSet(conf, (String)"flyway.installedBy", (Object[])new Object[]{this.installedBy, this.extension.installedBy});
        ConfigUtils.putIfSet(conf, (String)"flyway.encoding", (Object[])new Object[]{this.encoding, this.extension.encoding});
        ConfigUtils.putIfSet(conf, (String)"flyway.placeholderReplacement", (Object[])new Object[]{this.placeholderReplacement, this.extension.placeholderReplacement});
        ConfigUtils.putIfSet(conf, (String)"flyway.placeholderPrefix", (Object[])new Object[]{this.placeholderPrefix, this.extension.placeholderPrefix});
        ConfigUtils.putIfSet(conf, (String)"flyway.placeholderSuffix", (Object[])new Object[]{this.placeholderSuffix, this.extension.placeholderSuffix});
        ConfigUtils.putIfSet(conf, (String)"flyway.target", (Object[])new Object[]{this.target, this.extension.target});
        ConfigUtils.putIfSet(conf, (String)"flyway.outOfOrder", (Object[])new Object[]{this.outOfOrder, this.extension.outOfOrder});
        ConfigUtils.putIfSet(conf, (String)"flyway.validateOnMigrate", (Object[])new Object[]{this.validateOnMigrate, this.extension.validateOnMigrate});
        ConfigUtils.putIfSet(conf, (String)"flyway.cleanOnValidationError", (Object[])new Object[]{this.cleanOnValidationError, this.extension.cleanOnValidationError});
        ConfigUtils.putIfSet(conf, (String)"flyway.ignoreMissingMigrations", (Object[])new Object[]{this.ignoreMissingMigrations, this.extension.ignoreMissingMigrations});
        ConfigUtils.putIfSet(conf, (String)"flyway.ignoreFutureMigrations", (Object[])new Object[]{this.ignoreFutureMigrations, this.extension.ignoreFutureMigrations});
        ConfigUtils.putIfSet(conf, (String)"flyway.cleanDisabled", (Object[])new Object[]{this.cleanDisabled, this.extension.cleanDisabled});
        ConfigUtils.putIfSet(conf, (String)"flyway.baselineOnMigrate", (Object[])new Object[]{this.baselineOnMigrate, this.extension.baselineOnMigrate});
        ConfigUtils.putIfSet(conf, (String)"flyway.skipDefaultResolvers", (Object[])new Object[]{this.skipDefaultResolvers, this.extension.skipDefaultResolvers});
        ConfigUtils.putIfSet(conf, (String)"flyway.skipDefaultCallbacks", (Object[])new Object[]{this.skipDefaultCallbacks, this.extension.skipDefaultCallbacks});
        ConfigUtils.putIfSet(conf, (String)"flyway.schemas", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.schemas), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.schemas)});
        ConfigUtils.putIfSet(conf, (String)"flyway.locations", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.locations), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.locations)});
        ConfigUtils.putIfSet(conf, (String)"flyway.resolvers", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.resolvers), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.resolvers)});
        ConfigUtils.putIfSet(conf, (String)"flyway.callbacks", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.callbacks), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.callbacks)});
        ConfigUtils.putIfSet(conf, (String)"flyway.errorHandlers", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.errorHandlers), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.errorHandlers)});
        ConfigUtils.putIfSet(conf, (String)"flyway.dryRunOutput", (Object[])new Object[]{this.dryRunOutput, this.extension.dryRunOutput});
        if (this.placeholders != null) {
            for (Map.Entry<Object, Object> entry : this.placeholders.entrySet()) {
                conf.put("flyway.placeholders." + entry.getKey().toString(), entry.getValue().toString());
            }
        }
        if (this.extension.placeholders != null) {
            for (Map.Entry<Object, Object> entry : this.extension.placeholders.entrySet()) {
                conf.put("flyway.placeholders." + entry.getKey().toString(), entry.getValue().toString());
            }
        }
        AbstractFlywayTask.addConfigFromProperties(conf, this.getProject().getProperties());
        AbstractFlywayTask.addConfigFromProperties(conf, this.loadConfigurationFromConfigFiles(envVars));
        AbstractFlywayTask.addConfigFromProperties(conf, envVars);
        AbstractFlywayTask.addConfigFromProperties(conf, System.getProperties());
        AbstractFlywayTask.removeGradlePluginSpecificPropertiesToAvoidWarnings(conf);
        return conf;
    }

    private Map<String, String> loadConfigurationFromConfigFiles(Map<String, String> envVars) {
        String encoding = this.determineConfigurationFileEncoding(envVars);
        HashMap<String, String> conf = new HashMap<String, String>();
        for (File configFile : this.determineConfigFiles(envVars)) {
            conf.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
        return conf;
    }

    private Map<String, String> loadConfigurationFromDefaultConfigFiles(Map<String, String> envVars) {
        String encoding = this.determineConfigurationFileEncoding(envVars);
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.putAll(ConfigUtils.loadConfigurationFile((File)new File(System.getProperty("user.home") + "/" + "flyway.conf"), (String)encoding, (boolean)false));
        return conf;
    }

    private String determineConfigurationFileEncoding(Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (System.getProperties().containsKey("flyway.configFileEncoding")) {
            return System.getProperties().getProperty("flyway.configFileEncoding");
        }
        if (this.configFileEncoding != null) {
            return this.configFileEncoding;
        }
        if (this.extension.configFileEncoding != null) {
            return this.extension.configFileEncoding;
        }
        return "UTF-8";
    }

    private List<File> determineConfigFiles(Map<String, String> envVars) {
        ArrayList<File> configFiles = new ArrayList<File>();
        if (envVars.containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) {
                configFiles.add(this.toFile(file));
            }
            return configFiles;
        }
        if (System.getProperties().containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)System.getProperties().getProperty("flyway.configFiles"), (String)",")) {
                configFiles.add(this.toFile(file));
            }
            return configFiles;
        }
        if (this.getProject().getProperties().containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)System.getProperties().getProperty("flyway.configFiles"), (String)",")) {
                configFiles.add(this.toFile(file));
            }
            return configFiles;
        }
        if (this.configFiles != null) {
            for (String file : this.configFiles) {
                configFiles.add(this.toFile(file));
            }
            return configFiles;
        }
        if (this.extension.configFiles != null) {
            for (String file : this.extension.configFiles) {
                configFiles.add(this.toFile(file));
            }
            return configFiles;
        }
        return configFiles;
    }

    private File toFile(String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getProject().getProjectDir(), fileName);
    }

    private static void removeGradlePluginSpecificPropertiesToAvoidWarnings(Map<String, String> conf) {
        conf.remove("flyway.configFiles");
        conf.remove("flyway.configFileEncoding");
        conf.remove("flyway.version");
    }

    private static void addConfigFromProperties(Map<String, String> config, Properties properties) {
        for (String prop : properties.stringPropertyNames()) {
            if (!prop.startsWith("flyway.")) continue;
            config.put(prop, properties.getProperty(prop));
        }
    }

    private static void addConfigFromProperties(Map<String, String> config, Map<String, ?> properties) {
        for (String prop : properties.keySet()) {
            if (!prop.startsWith("flyway.")) continue;
            config.put(prop, properties.get(prop).toString());
        }
    }

    private void handleException(Throwable throwable) {
        String message = "Error occurred while executing " + this.getName();
        throw new FlywayException(this.collectMessages(throwable, message), throwable);
    }

    private String collectMessages(Throwable throwable, String message) {
        if (throwable != null) {
            message = message + "\n" + throwable.getMessage();
            return this.collectMessages(throwable.getCause(), message);
        }
        return message;
    }

    private boolean isJavaProject() {
        return this.getProject().getPluginManager().hasPlugin("java");
    }
}

