/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc.compiler;

import ca.coglinc.gradle.plugins.javacc.JavaccTaskException;
import ca.coglinc.gradle.plugins.javacc.compiler.SourceFileCompiler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;

class NonJavaccSourceFileVisitor
extends EmptyFileVisitor {
    private SourceFileCompiler compiler;

    NonJavaccSourceFileVisitor(SourceFileCompiler compiler) {
        this.compiler = compiler;
    }

    public void visitFile(FileVisitDetails fileDetails) {
        if (!this.isValidSourceFileForTask(fileDetails)) {
            File sourceFile = fileDetails.getFile();
            File destinationFile = new File(sourceFile.getAbsolutePath().replace(this.compiler.getInputDirectory().getAbsolutePath(), this.compiler.getOutputDirectory().getAbsolutePath()));
            this.copyFile(sourceFile, destinationFile);
        }
    }

    private void copyFile(File sourceFile, File destinationFile) {
        this.compiler.getLogger().debug("Copying non javacc source file from {} to {}", (Object)sourceFile.getAbsolutePath(), (Object)destinationFile.getAbsolutePath());
        try {
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
        }
        catch (IOException e) {
            throw new JavaccTaskException(String.format("Could not copy file %s to %s", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()), e);
        }
    }

    private boolean isValidSourceFileForTask(FileVisitDetails fileDetails) {
        return fileDetails.getName().toLowerCase().endsWith(this.compiler.supportedSuffix());
    }
}

