/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc.compiler;

import ca.coglinc.gradle.plugins.javacc.compiler.CompilerInputOutputConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.gradle.api.file.FileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;

public class JavaccCompilerInputOutputConfiguration
implements CompilerInputOutputConfiguration {
    private final File inputDirectory;
    private final File outputDirectory;
    private final FileTree source;
    private final Set<JavaCompile> javaCompileTasks;

    public JavaccCompilerInputOutputConfiguration(File inputDirectory, File outputDirectory, FileTree source, TaskCollection<JavaCompile> javaCompileTasks) {
        this.inputDirectory = inputDirectory;
        this.outputDirectory = outputDirectory;
        this.source = source;
        this.javaCompileTasks = new HashSet<JavaCompile>();
        if (!CollectionUtils.isEmpty(javaCompileTasks)) {
            this.javaCompileTasks.addAll((Collection<JavaCompile>)javaCompileTasks);
        }
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @Override
    public File getTempOutputDirectory() {
        return new File(this.getOutputDirectory(), "tmp");
    }

    @Override
    public FileTree getSource() {
        return this.source;
    }

    @Override
    public FileTree getCompleteSourceTree() {
        FileTree javaccTaskSourceTree = this.getSource();
        FileTree javaTasksSourceTree = this.getJavaSourceTree();
        FileTree completeSourceTree = javaTasksSourceTree == null ? javaccTaskSourceTree : javaccTaskSourceTree.plus(javaTasksSourceTree);
        return this.excludeOutputDirectory(completeSourceTree);
    }

    @Override
    public FileTree getJavaSourceTree() {
        FileTree javaSourceTree = null;
        for (JavaCompile task : this.javaCompileTasks) {
            if (javaSourceTree == null) {
                javaSourceTree = task.getSource();
                continue;
            }
            javaSourceTree = javaSourceTree.plus(task.getSource());
        }
        return this.excludeOutputDirectory(javaSourceTree);
    }

    private FileTree excludeOutputDirectory(FileTree sourceTree) {
        if (sourceTree == null) {
            return null;
        }
        Spec<File> outputDirectoryFilter = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                return file.getAbsolutePath().contains(JavaccCompilerInputOutputConfiguration.this.getOutputDirectory().getAbsolutePath());
            }
        };
        FileTree fileTree = sourceTree.minus(sourceTree.filter((Spec)outputDirectoryFilter)).getAsFileTree();
        return fileTree;
    }
}

