/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc.compilationresults;

import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFileOperationException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;

public class CompiledJavaccFile {
    private static final Pattern PACKAGE_DECLARATION_PATTERN = Pattern.compile("package\\s+([^\\s.;]+(\\.[^\\s.;]+)*)\\s*;");
    private File compiledJavaccFile;
    private File outputDirectory;
    private FileTree customAstClassesDirectory;
    private File targetDirectory;
    private Logger logger;

    CompiledJavaccFile(File file, File outputDirectory, FileTree customAstClassesDirectory, File targetDirectory, Logger logger) {
        this.compiledJavaccFile = file;
        this.outputDirectory = outputDirectory;
        this.customAstClassesDirectory = customAstClassesDirectory;
        this.targetDirectory = targetDirectory;
        this.logger = logger;
    }

    public boolean customAstClassExists() {
        return this.customAstClassExists(this.customAstClassesDirectory);
    }

    public boolean customAstClassExists(FileTree fileTree) {
        File customAstClassInputFile = this.getCustomAstClassInputFile(fileTree);
        return customAstClassInputFile != null && customAstClassInputFile.exists();
    }

    private File getCustomAstClassInputFile(FileTree fileTree) {
        String compiledJavaccFilePackage = this.getPackageName(this.compiledJavaccFile);
        if (fileTree != null) {
            Set sourceFiles = fileTree.getFiles();
            return this.scanSourceFiles(compiledJavaccFilePackage, sourceFiles);
        }
        return null;
    }

    private File scanSourceFiles(String compiledJavaccFilePackage, Collection<File> sourceFiles) {
        for (File sourceFile : sourceFiles) {
            String packageName;
            this.logger.debug("Scanning source file [{}] looking for a file named [{}] in package [{}]", new Object[]{sourceFile, this.compiledJavaccFile.getName(), compiledJavaccFilePackage});
            if (sourceFile.isDirectory()) {
                Collection childFiles = FileUtils.listFiles((File)sourceFile, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".java"), (IOFileFilter)TrueFileFilter.TRUE);
                File matchingChildFile = this.scanSourceFiles(compiledJavaccFilePackage, childFiles);
                if (matchingChildFile == null) continue;
                return matchingChildFile;
            }
            if (!FilenameUtils.isExtension((String)sourceFile.getName(), (String)"java") || !this.compiledJavaccFile.getName().equals(sourceFile.getName()) || !compiledJavaccFilePackage.equals(packageName = this.getPackageName(sourceFile))) continue;
            return sourceFile;
        }
        return null;
    }

    private String getPackageName(File file) {
        String fileContents = "";
        try {
            fileContents = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
        }
        catch (IOException e) {
            this.logger.warn("Could not read file contents for file [{}]", (Object)file);
        }
        Matcher matcher = PACKAGE_DECLARATION_PATTERN.matcher(fileContents);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public void copyCompiledFileToTargetDirectory() {
        this.logger.info("Custom AST class not found");
        File destination = new File(this.compiledJavaccFile.getAbsolutePath().replace(this.outputDirectory.getAbsolutePath(), this.targetDirectory.getAbsolutePath()));
        this.logger.info("Copying compiled file {} to {}", (Object)this.compiledJavaccFile, (Object)destination);
        try {
            FileUtils.copyFile((File)this.compiledJavaccFile, (File)destination);
        }
        catch (IOException e) {
            String errorMessage = String.format("Could not copy %s from %s to %s", this.compiledJavaccFile, this.outputDirectory, this.targetDirectory);
            throw new CompiledJavaccFileOperationException(errorMessage, e);
        }
    }

    public void copyCustomAstClassToTargetDirectory(FileTree sourceTree) {
        this.logger.info("Not copying compiled file {} from {} to {} because it is overridden by the custom AST class {}", new Object[]{this.compiledJavaccFile, this.outputDirectory, this.targetDirectory, this.getCustomAstClassInputFile(sourceTree)});
        String packagePath = this.getPackageName(this.compiledJavaccFile).replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        File destination = new File(this.targetDirectory.getAbsolutePath() + File.separator + packagePath, this.compiledJavaccFile.getName());
        this.logger.info("Copying custom AST class [{}] to [{}]", (Object)this.getCustomAstClassInputFile(sourceTree), (Object)destination);
        try {
            FileUtils.copyFile((File)this.getCustomAstClassInputFile(sourceTree), (File)destination);
        }
        catch (IOException e) {
            String errorMessage = String.format("Could not copy %s to %s", this.getCustomAstClassInputFile(sourceTree), this.targetDirectory);
            throw new CompiledJavaccFileOperationException(errorMessage, e);
        }
    }

    public void ignoreCompiledFileAndUseCustomAstClassFromJavaSourceTree(FileTree javaSourceTree) {
        this.logger.info("Ignoring compiled file {} because it is overridden by the custom AST class in Java source tree {}", (Object)this.compiledJavaccFile, (Object)this.getCustomAstClassInputFile(javaSourceTree));
    }

    public String toString() {
        return this.compiledJavaccFile.getAbsolutePath();
    }
}

