/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import ca.coglinc.gradle.plugins.javacc.CompileJavaccTask;
import ca.coglinc.gradle.plugins.javacc.CompileJjdocTask;
import ca.coglinc.gradle.plugins.javacc.CompileJjtreeTask;
import ca.coglinc.gradle.plugins.javacc.JavaToJavaccDependencyAction;
import com.google.common.util.concurrent.Callables;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;

public class JavaccPlugin
implements Plugin<Project> {
    public static final String GROUP = "JavaCC";

    public void apply(Project project) {
        Configuration configuration = this.createJavaccConfiguration(project);
        this.configureDefaultJavaccDependency(project, configuration);
        this.addCompileJavaccTaskToProject(project, configuration);
        this.addCompileJJTreeTaskToProject(project, configuration);
        this.addCompileJjdocTaskToProject(project, configuration);
        this.configureTaskDependencies(project);
    }

    private Configuration createJavaccConfiguration(Project project) {
        Configuration configuration = (Configuration)project.getConfigurations().create("javacc");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The javacc dependencies to be used.");
        return configuration;
    }

    private void configureDefaultJavaccDependency(final Project project, Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)project.getDependencies().create((Object)"net.java.dev.javacc:javacc:6.1.2"));
            }
        });
    }

    private void addCompileJavaccTaskToProject(Project project, Configuration configuration) {
        this.addTaskToProject(project, CompileJavaccTask.class, "compileJavacc", "Compiles JavaCC files into Java files", GROUP, configuration);
    }

    private void addCompileJJTreeTaskToProject(Project project, Configuration configuration) {
        this.addTaskToProject(project, CompileJjtreeTask.class, "compileJjtree", "Compiles JJTree files into JavaCC files", GROUP, configuration);
    }

    private void addCompileJjdocTaskToProject(Project project, Configuration configuration) {
        this.addTaskToProject(project, CompileJjdocTask.class, "jjdoc", "Takes a JavaCC parser specification and produces documentation for the BNF grammar", GROUP, configuration);
    }

    private void addTaskToProject(Project project, Class<? extends AbstractJavaccTask> type, String name, String description, String group, Configuration configuration) {
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        options.put("type", type);
        options.put("description", description);
        options.put("group", group);
        AbstractJavaccTask task = (AbstractJavaccTask)project.task(options, name);
        task.getConventionMapping().map("classpath", Callables.returning((Object)configuration));
    }

    private void configureTaskDependencies(Project project) {
        JavaToJavaccDependencyAction compileJavaDependsOnCompileJavacc = new JavaToJavaccDependencyAction();
        project.afterEvaluate((Action)compileJavaDependsOnCompileJavacc);
    }
}

