/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.CompileJavaccTask;
import ca.coglinc.gradle.plugins.javacc.CompileJjtreeTask;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;

public class JavaToJavaccDependencyAction
implements Action<Project> {
    public void execute(Project project) {
        if (!project.getPlugins().hasPlugin("java")) {
            return;
        }
        this.configureCompileJJTreeTask(project);
        this.configureCompileJavaccTask(project);
    }

    private void configureCompileJJTreeTask(Project project) {
        CompileJjtreeTask compileJjtreeTask = (CompileJjtreeTask)((Object)project.getTasks().findByName("compileJjtree"));
        if (compileJjtreeTask == null) {
            return;
        }
        if (!compileJjtreeTask.getSource().isEmpty()) {
            this.addJJTreeDependencyToJavaccCompileTask((TaskCollection<JavaCompile>)project.getTasks().withType(JavaCompile.class), (TaskCollection<CompileJavaccTask>)project.getTasks().withType(CompileJavaccTask.class), compileJjtreeTask);
        }
    }

    private void configureCompileJavaccTask(Project project) {
        CompileJavaccTask compileJavaccTask = (CompileJavaccTask)((Object)project.getTasks().findByName("compileJavacc"));
        if (compileJavaccTask != null) {
            this.addJavaccDependencyToJavaCompileTask((TaskCollection<JavaCompile>)project.getTasks().withType(JavaCompile.class), compileJavaccTask);
        }
    }

    private void addJavaccDependencyToJavaCompileTask(TaskCollection<JavaCompile> javaCompilationTasks, CompileJavaccTask compileJavaccTask) {
        for (JavaCompile task : javaCompilationTasks) {
            task.dependsOn(new Object[]{compileJavaccTask});
            task.source(new Object[]{compileJavaccTask.getOutputDirectory()});
        }
    }

    private void addJJTreeDependencyToJavaccCompileTask(TaskCollection<JavaCompile> javaCompilationTasks, TaskCollection<CompileJavaccTask> javaccCompilationTasks, CompileJjtreeTask compileJjtreeTask) {
        for (Object task : javaCompilationTasks) {
            task.dependsOn(new Object[]{compileJjtreeTask});
            task.source(new Object[]{compileJjtreeTask.getOutputDirectory()});
        }
        for (Object task : javaccCompilationTasks) {
            task.dependsOn(new Object[]{compileJjtreeTask});
            task.source(new Object[]{compileJjtreeTask.getOutputDirectory()});
        }
    }
}

