/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import ca.coglinc.gradle.plugins.javacc.compiler.JavaccCompilerInputOutputConfiguration;
import ca.coglinc.gradle.plugins.javacc.compiler.JavaccSourceFileCompiler;
import ca.coglinc.gradle.plugins.javacc.programexecution.JavaccProgramInvoker;
import ca.coglinc.gradle.plugins.javacc.programexecution.ProgramArguments;
import java.io.File;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;

public class CompileJavaccTask
extends AbstractJavaccTask {
    public static final String TASK_NAME_VALUE = "compileJavacc";
    public static final String TASK_DESCRIPTION_VALUE = "Compiles JavaCC files into Java files";
    private static final String DEFAULT_INPUT_DIRECTORY = File.separator + "src" + File.separator + "main" + File.separator + "javacc";
    private static final String DEFAULT_OUTPUT_DIRECTORY = File.separator + "generated" + File.separator + "javacc";

    public CompileJavaccTask() {
        super(DEFAULT_INPUT_DIRECTORY, DEFAULT_OUTPUT_DIRECTORY, "**/*.jj");
    }

    @TaskAction
    public void run() {
        TaskCollection javaCompileTasks = this.getProject().getTasks().withType(JavaCompile.class);
        JavaccCompilerInputOutputConfiguration inputOutputDirectories = new JavaccCompilerInputOutputConfiguration(this.getInputDirectory(), this.getOutputDirectory(), this.getSource(), (TaskCollection<JavaCompile>)javaCompileTasks);
        JavaccProgramInvoker javaccInvoker = new JavaccProgramInvoker(this.getProject(), this.getClasspath(), inputOutputDirectories.getTempOutputDirectory());
        ProgramArguments arguments = new ProgramArguments();
        arguments.addAll(this.getArguments());
        JavaccSourceFileCompiler compiler = new JavaccSourceFileCompiler(javaccInvoker, arguments, inputOutputDirectories, this.getLogger());
        compiler.createTempOutputDirectory();
        compiler.compileSourceFilesToTempOutputDirectory();
        compiler.copyCompiledFilesFromTempOutputDirectoryToOutputDirectory();
        compiler.copyNonJavaccFilesToOutputDirectory();
        compiler.cleanTempOutputDirectory();
    }
}

