/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.repository;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ReadOnlyRepository
implements Repository,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ReadOnlyRepository.class);
    private final URI root;
    private final ServerInfo serverInfo;
    private URI rootURI;
    public static final GBeanInfo GBEAN_INFO;

    public ReadOnlyRepository(File root) {
        this(root.toURI());
    }

    public ReadOnlyRepository(URI rootURI) {
        this.root = null;
        this.serverInfo = null;
        this.rootURI = rootURI;
    }

    public ReadOnlyRepository(URI root, ServerInfo serverInfo) {
        this.root = root;
        this.serverInfo = serverInfo;
    }

    public boolean hasURI(URI uri) {
        if ("file".equals((uri = this.resolve(uri)).getScheme())) {
            File f = new File(uri);
            return f.exists() && f.canRead();
        }
        try {
            uri.toURL().openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public URL getURL(URI uri) throws MalformedURLException {
        return this.resolve(uri).toURL();
    }

    private URI resolve(URI uri) {
        String[] bits = uri.toString().split("/");
        StringBuffer buf = new StringBuffer(bits[0]).append('/');
        String type = bits.length >= 4 ? bits[3] : "jar";
        buf.append(type).append('s').append('/').append(bits[1]).append('-').append(bits[2]).append('.').append(type);
        return this.rootURI.resolve(buf.toString());
    }

    public void doStart() throws Exception {
        if (this.rootURI == null) {
            this.rootURI = this.serverInfo.resolve(this.root);
        }
        log.debug((Object)("Repository root is " + this.rootURI));
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)ReadOnlyRepository.class);
        infoFactory.addAttribute("root", URI.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(Repository.class);
        infoFactory.setConstructor(new String[]{"root", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

