/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.main.WebAppUtil;

public class LongStartupMonitor
implements StartupMonitor {
    private static final Log log = LogFactory.getLog((String)LongStartupMonitor.class.getName());
    private static final int MIN_TIME_WIDTH = 3;
    private PrintStream out;
    private int numConfigs;
    private int numConfigsDigits;
    private int configNum;
    private long started;
    private long configStarted;
    private Kernel kernel;

    public void systemStarting(long startTime) {
        this.out = System.out;
        this.started = startTime;
    }

    public void systemStarted(Kernel kernel) {
        this.kernel = kernel;
    }

    public synchronized void foundConfigurations(URI[] configurations) {
        this.numConfigs = configurations.length;
        this.numConfigsDigits = Integer.toString(this.numConfigs).length();
    }

    public synchronized void configurationLoading(URI configuration) {
        ++this.configNum;
    }

    public synchronized void configurationLoaded(URI configuration) {
    }

    public synchronized void configurationStarting(URI configuration) {
        this.configStarted = System.currentTimeMillis();
    }

    public synchronized void configurationStarted(URI configuration) {
        int time = Math.round((float)(System.currentTimeMillis() - this.configStarted) / 1000.0f);
        StringBuffer buf = new StringBuffer();
        buf.append("Started configuration ");
        for (int configIndexDigits = Integer.toString(this.configNum).length(); configIndexDigits < this.numConfigsDigits; ++configIndexDigits) {
            buf.append(' ');
        }
        buf.append(this.configNum).append('/').append(this.numConfigs).append(' ');
        for (int timeDigits = Integer.toString(time).length(); timeDigits < 3; ++timeDigits) {
            buf.append(' ');
        }
        buf.append(time + "s " + configuration);
        this.out.println(buf.toString());
    }

    public synchronized void startupFinished() {
        int time = Math.round((float)(System.currentTimeMillis() - this.started) / 1000.0f);
        this.out.println("Startup completed in " + time + " seconds");
        this.wrapUp();
    }

    private void wrapUp() {
        ArrayList<String> apps = new ArrayList<String>();
        ArrayList<WebAppInfo> webs = new ArrayList<WebAppInfo>();
        ArrayList<AddressHolder> ports = new ArrayList<AddressHolder>();
        Map containers = new HashMap();
        HashMap<ObjectName, String> failed = new HashMap<ObjectName, String>();
        String serverInfo = null;
        try {
            Set gbeans = this.kernel.listGBeans(ObjectName.getInstance("*:*"));
            HashMap beanInfos = new HashMap();
            Iterator it = gbeans.iterator();
            while (it.hasNext()) {
                ArrayList<GAttributeInfo> list;
                int stateValue;
                ObjectName name = (ObjectName)it.next();
                if (LongStartupMonitor.isApplicationModule(name)) {
                    apps.add("    " + LongStartupMonitor.decodeModule(name.getKeyProperty("j2eeType")) + ": " + name.getKeyProperty("name"));
                }
                if (LongStartupMonitor.isWebModule(name)) {
                    String webAppName = name.getCanonicalName();
                    String context = (String)this.kernel.getAttribute(name, "contextPath");
                    String containerName = (String)this.kernel.getAttribute(name, "containerName");
                    webs.add(new WebAppInfo(containerName, webAppName, context));
                }
                if ((stateValue = this.kernel.getGBeanState(name)) != 1) {
                    GBeanData data = this.kernel.getGBeanData(name);
                    State state = State.fromInt((int)stateValue);
                    StringBuffer buf = new StringBuffer();
                    buf.append("(").append(state.getName());
                    if (data != null && data.getAttributes() != null) {
                        Map map = data.getAttributes();
                        Iterator it2 = map.keySet().iterator();
                        while (it2.hasNext()) {
                            String att = (String)it2.next();
                            if (!att.equals("port") && att.indexOf("Port") <= -1) continue;
                            buf.append(",").append(att).append("=").append(map.get(att));
                        }
                    }
                    buf.append(")");
                    failed.put(name, buf.toString());
                    continue;
                }
                GBeanInfo info = this.kernel.getGBeanInfo(name);
                if (info.getClassName().equals("org.apache.geronimo.system.serverinfo.ServerInfo")) {
                    serverInfo = (String)this.kernel.getAttribute(name, "version");
                }
                if ((list = (ArrayList<GAttributeInfo>)beanInfos.get(info)) == null) {
                    list = new ArrayList<GAttributeInfo>(3);
                    beanInfos.put(info, list);
                    Set atts = info.getAttributes();
                    Iterator it2 = atts.iterator();
                    while (it2.hasNext()) {
                        GAttributeInfo att = (GAttributeInfo)it2.next();
                        if (!att.getType().equals("java.net.InetSocketAddress")) continue;
                        list.add(att);
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    GAttributeInfo att = (GAttributeInfo)list.get(i);
                    try {
                        InetSocketAddress addr = (InetSocketAddress)this.kernel.getAttribute(name, att.getName());
                        if (addr == null) {
                            log.debug((Object)("No value for GBean " + name + " attribute " + att.getName()));
                            continue;
                        }
                        if (addr.getAddress() == null || addr.getAddress().getHostAddress() == null) {
                            log.debug((Object)("Null address or host for GBean " + name + " " + att.getName() + ": " + addr.getAddress()));
                        }
                        String attName = info.getName();
                        if (list.size() > 1) {
                            attName = attName + " " + LongStartupMonitor.decamelize(att.getName());
                        } else if (info.getAttribute("name") != null) {
                            attName = attName + " " + this.kernel.getAttribute(name, "name");
                        }
                        ports.add(new AddressHolder(attName, addr));
                        continue;
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
            }
            containers = WebAppUtil.mapContainersToURLs(this.kernel);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (GBeanNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAttributeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ports.size() > 0) {
            AddressHolder holder;
            int i;
            Collections.sort(ports);
            System.out.println("  Listening on Ports:");
            int max = 0;
            for (i = 0; i < ports.size(); ++i) {
                holder = (AddressHolder)ports.get(i);
                if (holder.getAddress().getAddress() == null || holder.getAddress().getAddress().getHostAddress() == null) continue;
                max = Math.max(max, holder.getAddress().getAddress().getHostAddress().length());
            }
            for (i = 0; i < ports.size(); ++i) {
                holder = (AddressHolder)ports.get(i);
                StringBuffer buf = new StringBuffer();
                buf.append("   ");
                if (holder.getAddress().getPort() < 10) {
                    buf.append(' ');
                }
                if (holder.getAddress().getPort() < 100) {
                    buf.append(' ');
                }
                if (holder.getAddress().getPort() < 1000) {
                    buf.append(' ');
                }
                if (holder.getAddress().getPort() < 10000) {
                    buf.append(' ');
                }
                buf.append(holder.getAddress().getPort()).append(' ');
                String address = holder.getAddress().getAddress() == null || holder.getAddress().getAddress().getHostAddress() == null ? "" : holder.getAddress().getAddress().getHostAddress();
                buf.append(address);
                for (int j = address.length(); j <= max; ++j) {
                    buf.append(' ');
                }
                buf.append(holder.getName());
                this.out.println(buf.toString());
            }
            this.out.println();
        }
        if (apps.size() > 0) {
            this.out.println("  Started Application Modules:");
            for (int i = 0; i < apps.size(); ++i) {
                this.out.println((String)apps.get(i));
            }
            this.out.println();
        }
        if (webs.size() > 0) {
            Collections.sort(webs);
            this.out.println("  Web Applications:");
            for (int i = 0; i < webs.size(); ++i) {
                WebAppInfo app = (WebAppInfo)webs.get(i);
                this.out.println("    " + containers.get(app.getContainerObjectName()) + app.getContext());
            }
            this.out.println();
        }
        if (failed.size() > 0) {
            this.out.println("  WARNING: Some GBeans were not started successfully:");
            Iterator it = failed.keySet().iterator();
            while (it.hasNext()) {
                ObjectName name = (ObjectName)it.next();
                String state = (String)failed.get(name);
                if (name.getKeyProperty("name") != null) {
                    log.debug((Object)("Unable to start " + name + " " + state));
                    this.out.println("    " + name.getKeyProperty("name") + " " + state);
                    continue;
                }
                this.out.println("    " + name + " " + state);
            }
            this.out.println();
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Geronimo Application Server started");
        if (serverInfo != null) {
            msg.append(" (version ").append(serverInfo).append(")");
        }
        this.out.println(msg.toString());
        this.out.flush();
    }

    public synchronized void loadFailed(String configuration, Exception problem) {
        this.out.println("Failed to load configuration " + configuration);
        this.out.println();
        problem.printStackTrace(this.out);
    }

    public synchronized void serverStartFailed(Exception problem) {
        this.out.println("Server Startup failed");
        this.out.println();
        problem.printStackTrace(this.out);
    }

    public synchronized void startFailed(String configuration, Exception problem) {
        this.out.println("Failed to start configuration " + configuration);
        problem.printStackTrace(this.out);
    }

    private static boolean isApplicationModule(ObjectName on) {
        String type = on.getKeyProperty("j2eeType");
        String app = on.getKeyProperty("J2EEApplication");
        String name = on.getKeyProperty("name");
        if (type != null && (app == null || app.equals("null"))) {
            return (type.equals("WebModule") || type.equals("J2EEApplication") || type.equals("EJBModule") || type.equals("AppClientModule") || type.equals("ResourceAdapterModule")) && !name.startsWith("org/apache/geronimo/System");
        }
        return false;
    }

    private static boolean isWebModule(ObjectName on) {
        String type = on.getKeyProperty("j2eeType");
        return type != null && type.equals("WebModule");
    }

    private static String decodeModule(String value) {
        if (value.equals("WebModule")) {
            return "WAR";
        }
        if (value.equals("J2EEApplication")) {
            return "EAR";
        }
        if (value.equals("EJBModule")) {
            return "JAR";
        }
        if (value.equals("AppClientModule")) {
            return "CAR";
        }
        if (value.equals("ResourceAdapterModule")) {
            return "RAR";
        }
        return "UNK";
    }

    private static String decamelize(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(Character.toUpperCase(s.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i)) && s.length() > i + 1 && Character.isLowerCase(s.charAt(i + 1))) {
                buf.append(" ");
            }
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private static class WebAppInfo
    implements Comparable {
        private String containerObjectName;
        private String webAppObjectName;
        private String context;

        public WebAppInfo(String containerObjectName, String webAppObjectName, String context) {
            this.containerObjectName = containerObjectName;
            this.webAppObjectName = webAppObjectName;
            this.context = context;
        }

        public String getContainerObjectName() {
            return this.containerObjectName;
        }

        public String getWebAppObjectName() {
            return this.webAppObjectName;
        }

        public String getContext() {
            return this.context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WebAppInfo)) {
                return false;
            }
            WebAppInfo webAppInfo = (WebAppInfo)o;
            if (!this.containerObjectName.equals(webAppInfo.containerObjectName)) {
                return false;
            }
            if (!this.context.equals(webAppInfo.context)) {
                return false;
            }
            return this.webAppObjectName.equals(webAppInfo.webAppObjectName);
        }

        public int hashCode() {
            int result = this.containerObjectName.hashCode();
            result = 29 * result + this.webAppObjectName.hashCode();
            result = 29 * result + this.context.hashCode();
            return result;
        }

        public int compareTo(Object o) {
            WebAppInfo other = (WebAppInfo)o;
            int test = this.containerObjectName.compareTo(other.containerObjectName);
            if (test != 0) {
                return test;
            }
            return this.context.compareTo(other.context);
        }
    }

    private static class AddressHolder
    implements Comparable {
        private String name;
        private InetSocketAddress address;

        public AddressHolder(String name, InetSocketAddress address) {
            this.name = name;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetSocketAddress address) {
            this.address = address;
        }

        public int compareTo(Object o) {
            AddressHolder other = (AddressHolder)o;
            int value = this.address.getPort() - other.address.getPort();
            return value == 0 ? this.address.getAddress().toString().compareTo(other.address.getAddress().toString()) : value;
        }
    }
}

