/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ServerOverride {
    private final Map configurations = new LinkedHashMap();

    public ServerOverride() {
    }

    public ServerOverride(Element element) throws MalformedObjectNameException {
        NodeList configs = element.getElementsByTagName("configuration");
        for (int i = 0; i < configs.getLength(); ++i) {
            Element configurationElement = (Element)configs.item(i);
            ConfigurationOverride configuration = new ConfigurationOverride(configurationElement);
            this.addConfiguration(configuration);
        }
    }

    public ConfigurationOverride getConfiguration(String configurationName) {
        return this.getConfiguration(configurationName, false);
    }

    public ConfigurationOverride getConfiguration(String configurationName, boolean create) {
        ConfigurationOverride configuration = (ConfigurationOverride)this.configurations.get(configurationName);
        if (create && configuration == null) {
            configuration = new ConfigurationOverride(configurationName, true);
            this.configurations.put(configurationName, configuration);
        }
        return configuration;
    }

    public void addConfiguration(ConfigurationOverride configuration) {
        this.configurations.put(configuration.getName(), configuration);
    }

    public void removeConfiguration(String configurationName) {
        this.configurations.remove(configurationName);
    }

    public Map getConfigurations() {
        return this.configurations;
    }

    public void writeXml(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println();
        out.println("<!-- ======================================================== -->");
        out.println("<!-- Warning - This XML file is re-generated by Geronimo when -->");
        out.println("<!-- changes are made to Geronimo's configuration, therefore  -->");
        out.println("<!-- any comments added to this file will be lost.            -->");
        out.println("<!-- Do not edit this file whilst Geronimo is running.        -->");
        out.println("<!-- ======================================================== -->");
        out.println();
        out.println("<attributes xmlns=\"http://geronimo.apache.org/xml/ns/attributes\">");
        Iterator it = this.configurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ConfigurationOverride configurationOverride = (ConfigurationOverride)entry.getValue();
            configurationOverride.writeXml(out);
        }
        out.println("</attributes>");
        out.close();
    }
}

