/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class FileConfigurationList
implements GBeanLifecycle,
PersistentConfigurationList {
    private static final Log log = LogFactory.getLog((Class)PersistentConfigurationList.class);
    private final Kernel kernel;
    private final ConfigurationManager configurationManager;
    private final ServerInfo serverInfo;
    private final String configFile;
    private boolean kernelFullyStarted = false;
    private File configList;
    private LifecycleListener listener;
    public static final GBeanInfo GBEAN_INFO;

    public FileConfigurationList(Kernel kernel, ServerInfo serverInfo, ConfigurationManager configurationManager, String configDir) {
        this.kernel = kernel;
        this.configurationManager = configurationManager;
        this.serverInfo = serverInfo;
        this.configFile = configDir;
        this.listener = new LifecycleAdapter(){

            public void stopped(ObjectName objectName) {
                if (FileConfigurationList.this.kernelFullyStarted && FileConfigurationList.this.kernel.isRunning()) {
                    this.doSave();
                }
            }

            public void running(ObjectName objectName) {
                if (FileConfigurationList.this.kernelFullyStarted && FileConfigurationList.this.kernel.isRunning()) {
                    this.doSave();
                }
            }

            private void doSave() {
                try {
                    FileConfigurationList.this.save();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to save list of running configurations", (Throwable)e);
                }
            }
        };
    }

    public void doStart() throws Exception {
        this.configList = this.serverInfo.resolve(this.configFile);
        File parent = this.configList.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory for list:" + parent);
        }
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, new ObjectName("geronimo.config:*"));
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public void doFail() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        this.configList = null;
    }

    public synchronized boolean isKernelFullyStarted() {
        return this.kernelFullyStarted;
    }

    public synchronized void setKernelFullyStarted(boolean kernelFullyStarted) {
        this.kernelFullyStarted = kernelFullyStarted;
    }

    public synchronized void save() throws IOException {
        if (!this.kernelFullyStarted) {
            log.debug((Object)"Configuration list was not saved.  Kernel was never fully started.");
            return;
        }
        if (!this.kernel.isRunning()) {
            log.debug((Object)"Configuration list was not saved.  Kernel is shutting down.");
            return;
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.configList));
        try {
            List stores = this.configurationManager.listStores();
            Iterator i = stores.iterator();
            while (i.hasNext()) {
                ObjectName storeName = (ObjectName)i.next();
                List configList = this.configurationManager.listConfigurations(storeName);
                Iterator j = configList.iterator();
                while (j.hasNext()) {
                    ConfigurationInfo info = (ConfigurationInfo)j.next();
                    if (info.getState() != State.RUNNING) continue;
                    writer.write(info.getConfigID().toString());
                    writer.newLine();
                }
            }
            writer.close();
        }
        catch (NoSuchStoreException e) {
            writer.close();
            this.configList.delete();
        }
        log.info((Object)"Saved running configuration list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List restore() throws IOException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(this.configList);
        }
        catch (FileNotFoundException e) {
            return Collections.EMPTY_LIST;
        }
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            ArrayList<URI> configs = new ArrayList<URI>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                try {
                    configs.add(new URI(line));
                }
                catch (URISyntaxException e) {
                    throw new IOException("Invalid URI in config list: " + line);
                }
            }
            ArrayList<URI> arrayList = configs;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    public void addConfiguration(String configName) {
        try {
            this.save();
        }
        catch (IOException e) {
            log.warn((Object)("Couldn't save while adding " + configName), (Throwable)e);
        }
    }

    public void removeConfiguration(String configName) {
        try {
            this.save();
        }
        catch (IOException e) {
            log.warn((Object)("Couldnt save while removing " + configName), (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)FileConfigurationList.class, (String)"PersistentConfigurationList");
        infoFactory.addInterface(PersistentConfigurationList.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("kernelFullyStarted", Boolean.TYPE, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("ConfigurationManager", ConfigurationManager.class, "ConfigurationManager");
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.setConstructor(new String[]{"kernel", "ServerInfo", "ConfigurationManager", "configFile"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

