/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.springframework.security.core.userdetails.memory;

import fr.xebia.springframework.security.core.userdetails.ExtendedUser;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserMap;
import org.springframework.util.StringUtils;

public class ExtendedUserMapBuilder {
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";

    public static UserMap buildUserMapFromProperties(UserMap userMap, Properties usersAttributes) {
        if (usersAttributes == null) {
            return userMap;
        }
        for (Map.Entry<Object, Object> entry : usersAttributes.entrySet()) {
            String userAttributes = entry.getKey() + "=" + entry.getValue();
            ExtendedUser user = ExtendedUserMapBuilder.buildExtendedUser(userAttributes);
            if (user == null) continue;
            userMap.addUser((UserDetails)user);
        }
        return userMap;
    }

    protected static ExtendedUser buildExtendedUser(String userAttributes) {
        String[] remainingAttributes;
        if (userAttributes == null) {
            return null;
        }
        String[] userAttributesStringArray = StringUtils.delimitedListToStringArray((String)userAttributes, (String)"=");
        if (userAttributesStringArray.length != 2) {
            return null;
        }
        String username = userAttributesStringArray[0].trim();
        Pattern pattern = Pattern.compile("(enabled|disabled){1}$");
        Matcher matcher = pattern.matcher(userAttributesStringArray[1].trim());
        boolean activated = true;
        if (matcher.find()) {
            activated = ENABLED.equals(matcher.group());
        }
        String allowedIpAddresses = "";
        pattern = Pattern.compile("@\\(.*\\)");
        matcher = pattern.matcher(userAttributesStringArray[1]);
        if (matcher.find()) {
            allowedIpAddresses = StringUtils.deleteAny((String)matcher.group(), (String)"@() ");
        }
        if ((remainingAttributes = (pattern = Pattern.compile("((,\\ *@\\(.*\\)){0,1}(\\ *,\\ *(enabled|disabled)\\ *){0,1})$")).split(userAttributesStringArray[1])).length != 1) {
            return null;
        }
        String[] attributes = StringUtils.commaDelimitedListToStringArray((String)remainingAttributes[0]);
        if (attributes.length < 2) {
            return null;
        }
        String password = attributes[0].trim();
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (int i = 1; i < attributes.length; ++i) {
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(attributes[i].trim()));
        }
        ExtendedUser extendedUser = new ExtendedUser(username, password, activated, true, true, true, authorities);
        extendedUser.setAllowedRemoteAddresses(allowedIpAddresses);
        return extendedUser;
    }
}

