/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.springframework.security.core.userdetails.jdbc;

import fr.xebia.springframework.security.core.userdetails.ExtendedUser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.provisioning.UserDetailsManager;

public class ExtendedJdbcUserDetailsManager
extends JdbcUserDetailsManager
implements UserDetailsManager {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String selectUserExtraColumns = "SELECT allowedRemoteAddresses, comments FROM users WHERE username = ?";
    private String updateUserExtraColumns = "UPDATE users set allowedRemoteAddresses= ?, comments= ? WHERE username = ?";

    public void createUser(UserDetails user) {
        super.createUser(user);
        this.updateUserExtraColumns(user);
    }

    protected UserDetails createUserDetails(String username, UserDetails userFromUserQuery, List<GrantedAuthority> combinedAuthorities) {
        final User user = (User)super.createUserDetails(username, userFromUserQuery, combinedAuthorities);
        List users = this.getJdbcTemplate().query(this.selectUserExtraColumns, (Object[])new String[]{username}, (RowMapper)new RowMapper<UserDetails>(){

            public UserDetails mapRow(ResultSet rs, int rowNum) throws SQLException {
                ExtendedUser extendedUser = new ExtendedUser(user.getUsername(), user.getPassword(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), user.getAuthorities());
                extendedUser.setAllowedRemoteAddresses(rs.getString(1));
                extendedUser.setComments(rs.getString(2));
                return extendedUser;
            }
        });
        if (users.size() == 0) {
            throw new UsernameNotFoundException(this.messages.getMessage("JdbcDaoImpl.notFound", new Object[]{username}, "Username {0} not found"), (Object)username);
        }
        return (UserDetails)users.get(0);
    }

    public String getSelectUserExtraColumns() {
        return this.selectUserExtraColumns;
    }

    public String getUpdateUserExtraColumns() {
        return this.updateUserExtraColumns;
    }

    public void setSelectUserExtraColumns(String selectUserExtraColumns) {
        this.selectUserExtraColumns = selectUserExtraColumns;
    }

    public void setUpdateUserExtraColumns(String updateUserExtraColumns) {
        this.updateUserExtraColumns = updateUserExtraColumns;
    }

    public void updateUser(UserDetails user) {
        super.updateUser(user);
        this.updateUserExtraColumns(user);
    }

    protected void updateUserExtraColumns(UserDetails user) {
        if (user instanceof ExtendedUser) {
            final ExtendedUser extendedUser = (ExtendedUser)user;
            int updatedRows = this.getJdbcTemplate().update(this.updateUserExtraColumns, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, extendedUser.getAllowedRemoteAddresses());
                    ps.setString(2, extendedUser.getComments());
                    ps.setString(3, extendedUser.getUsername());
                }
            });
            if (updatedRows != 1) {
                this.log.warn((Object)("More/less (" + updatedRows + ") than one row have been updated modifying 'allowedRemoteIpAddresses' to '" + extendedUser.getAllowedRemoteAddresses() + "' and 'comments' to '" + extendedUser.getComments() + "' for username '" + extendedUser.getUsername() + "'"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Given user " + user + " is not an ExtendedUser, no additional column to update."));
        }
    }
}

