/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.springframework.security.core.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public class ExtendedUser
extends User
implements UserDetails {
    private static final long serialVersionUID = 1L;
    protected List<Pattern> allowedRemoteAddresses = new ArrayList<Pattern>();
    protected String comments;

    public ExtendedUser(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<GrantedAuthority> authorities) throws IllegalArgumentException {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }

    public ExtendedUser(UserDetails userDetails) {
        super(userDetails.getUsername(), userDetails.getPassword(), userDetails.isEnabled(), userDetails.isAccountNonExpired(), userDetails.isCredentialsNonExpired(), userDetails.isAccountNonLocked(), userDetails.getAuthorities());
    }

    public boolean equals(Object rhs) {
        return super.equals(rhs);
    }

    public String getAllowedRemoteAddresses() {
        return StringUtils.collectionToCommaDelimitedString(this.allowedRemoteAddresses);
    }

    public List<Pattern> getAllowedRemoteAddressesPatterns() {
        return this.allowedRemoteAddresses;
    }

    public String getComments() {
        return this.comments;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setAllowedRemoteAddresses(List<Pattern> allowedRemoteAddresses) {
        this.allowedRemoteAddresses = allowedRemoteAddresses;
    }

    public void setAllowedRemoteAddresses(String allowedRemoteAddresses) {
        allowedRemoteAddresses = StringUtils.replace((String)allowedRemoteAddresses, (String)";", (String)",");
        String[] allowedRemoteAddressesAsArray = StringUtils.commaDelimitedListToStringArray((String)allowedRemoteAddresses);
        ArrayList<Pattern> newAllowedRemoteAddresses = new ArrayList<Pattern>();
        for (String allowedRemoteAddress : allowedRemoteAddressesAsArray) {
            allowedRemoteAddress = StringUtils.trimWhitespace((String)allowedRemoteAddress);
            try {
                newAllowedRemoteAddresses.add(Pattern.compile(allowedRemoteAddress));
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Exception parsing allowedRemoteAddress '" + allowedRemoteAddress + "' for user '" + this.getUsername() + "'", e);
            }
        }
        this.allowedRemoteAddresses = newAllowedRemoteAddresses;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String toString() {
        return super.toString() + "; allowedRemoteAddresses: " + this.allowedRemoteAddresses;
    }
}

