/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.springframework.security.core.providers;

import fr.xebia.springframework.security.core.userdetails.ExtendedUser;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class ExtendedDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        List<Pattern> allowedRemoteAddressesPatterns;
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (!(userDetails instanceof ExtendedUser)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Given userDetails '" + userDetails + "' is not an ExtendedUser, skip ipAddress verification"));
            }
            return;
        }
        ExtendedUser extendedUser = (ExtendedUser)userDetails;
        if (!(authentication.getDetails() instanceof WebAuthenticationDetails)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Given authentication '" + authentication + "' does not hold WebAuthenticationDetails, skip ipAddress verification"));
            }
            return;
        }
        WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)authentication.getDetails();
        String remoteIpAddress = webAuthenticationDetails.getRemoteAddress();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Evaluate permission for '" + (Object)((Object)extendedUser) + "' to authenticate from ip address " + remoteIpAddress));
        }
        if (!this.matchesOneAddress(remoteIpAddress, allowedRemoteAddressesPatterns = extendedUser.getAllowedRemoteAddressesPatterns())) {
            throw new BadCredentialsException("Access denied from IP : " + remoteIpAddress);
        }
    }

    protected boolean matchesOneAddress(String ipAddress, List<Pattern> allowedIpAddresses) {
        if (allowedIpAddresses.isEmpty()) {
            return true;
        }
        for (Pattern allowedIpAddress : allowedIpAddresses) {
            if (!allowedIpAddress.matcher(ipAddress).matches()) continue;
            return true;
        }
        return false;
    }
}

