/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.audit;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class Auditor {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"fr.xebia.audit");
    private static SimpleDateFormat dateFormatPrototype = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public static void audit(String message) {
        if (message == null) {
            message = "";
        }
        StringBuilder msg = new StringBuilder(40 + message.length());
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormatPrototype.clone();
        msg.append(simpleDateFormat.format(new Date()));
        msg.append(" ").append(message).append(" by ");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            msg.append("anonymous");
        } else {
            msg.append(authentication.getName());
            if (authentication.getDetails() instanceof WebAuthenticationDetails) {
                WebAuthenticationDetails details = (WebAuthenticationDetails)authentication.getDetails();
                msg.append(" coming from " + details.getRemoteAddress());
            }
        }
        auditLogger.info(msg.toString());
    }
}

