/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.audit;

import fr.xebia.audit.Audited;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

@Aspect
public class AuditAspect {
    private SimpleDateFormat dateFormatPrototype = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>();
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private Logger logger = LoggerFactory.getLogger((String)"fr.xebia.audit");
    private ParserContext parserContext = new TemplateParserContext();

    protected static void appendThrowableCauses(Throwable throwable, String separator, StringBuilder toAppendTo) {
        ArrayList<Throwable> alreadyAppendedThrowables = new ArrayList<Throwable>();
        while (throwable != null) {
            toAppendTo.append(throwable.toString());
            alreadyAppendedThrowables.add(throwable);
            Throwable cause = throwable.getCause();
            if (cause == null || alreadyAppendedThrowables.contains(cause)) break;
            throwable = cause;
            toAppendTo.append(separator);
        }
    }

    protected String buildMessage(String template, Object invokedObject, Object[] args, Object returned, Throwable throwned, long durationInNanos) {
        try {
            Expression expression = this.expressionCache.get(template);
            if (expression == null) {
                expression = this.expressionParser.parseExpression(template, this.parserContext);
                this.expressionCache.put(template, expression);
            }
            String evaluatedMessage = (String)expression.getValue((Object)new RootObject(invokedObject, args, returned, throwned), String.class);
            StringBuilder msg = new StringBuilder();
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormatPrototype.clone();
            msg.append(simpleDateFormat.format(new Date()));
            msg.append(" ").append(evaluatedMessage);
            if (throwned != null) {
                msg.append(" threw '");
                AuditAspect.appendThrowableCauses(throwned, ", ", msg);
                msg.append("'");
            }
            msg.append(" by ");
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null) {
                msg.append("anonymous");
            } else {
                msg.append(authentication.getName());
                if (authentication.getDetails() instanceof WebAuthenticationDetails) {
                    WebAuthenticationDetails details = (WebAuthenticationDetails)authentication.getDetails();
                    msg.append(" coming from " + details.getRemoteAddress());
                }
            }
            msg.append(" in ").append(TimeUnit.MILLISECONDS.convert(durationInNanos, TimeUnit.NANOSECONDS)).append(" ms");
            return msg.toString();
        }
        catch (RuntimeException e) {
            StringBuilder msg = new StringBuilder("Exception evaluating template '" + template + "': ");
            AuditAspect.appendThrowableCauses(e, ", ", msg);
            return msg.toString();
        }
    }

    @Around(value="execution(* *(..)) && @annotation(audited)", argNames="pjp,audited")
    public Object logMessage(ProceedingJoinPoint pjp, Audited audited) throws Throwable {
        long nanosBefore = System.nanoTime();
        try {
            Object returned = pjp.proceed();
            long durationInNanos = System.nanoTime() - nanosBefore;
            String message = this.buildMessage(audited.message(), pjp.getThis(), pjp.getArgs(), returned, null, durationInNanos);
            this.logger.info(message);
            return returned;
        }
        catch (Throwable t) {
            long durationInNanos = System.nanoTime() - nanosBefore;
            String message = this.buildMessage(audited.message(), pjp.getThis(), pjp.getArgs(), null, t, durationInNanos);
            this.logger.warn(message);
            throw t;
        }
    }

    private static class TemplateParserContext
    implements ParserContext {
        private TemplateParserContext() {
        }

        public String getExpressionPrefix() {
            return "#{";
        }

        public String getExpressionSuffix() {
            return "}";
        }

        public boolean isTemplate() {
            return true;
        }
    }

    protected static class RootObject {
        private final Object[] args;
        private final Object invokedObject;
        private final Object returned;
        private final Throwable throwned;

        private RootObject(Object invokedObject, Object[] args, Object returned, Throwable throwned) {
            this.invokedObject = invokedObject;
            this.args = args;
            this.returned = returned;
            this.throwned = throwned;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object getInvokedObject() {
            return this.invokedObject;
        }

        public Object getReturned() {
            return this.returned;
        }

        public Throwable getThrowned() {
            return this.throwned;
        }
    }
}

