/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma;

import fr.xebia.extras.selma.SelmaException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Selma {
    private static final Map<String, Object> mappers = new ConcurrentHashMap<String, Object>();
    public static final String SET_CUSTOM_MAPPER = "setCustomMapper";
    public static final String SET_FACTORY = "setFactory";

    public static <T> MapperBuilder<T> builder(Class<T> mapperClass) {
        return new MapperBuilder(mapperClass);
    }

    public static <T> T mapper(Class<T> mapperClass) throws IllegalArgumentException {
        return Selma.getMapper(mapperClass, null, null);
    }

    public static <T, V> T mapper(Class<T> mapperClass, V source) {
        return Selma.getMapper(mapperClass, source, null);
    }

    public static <T> T getMapper(Class<T> mapperClass) {
        return Selma.getMapper(mapperClass, null, null);
    }

    public static <T, V> T getMapperWithCustom(Class<T> mapperClass, V custom) {
        return Selma.getMapper(mapperClass, null, custom);
    }

    public static synchronized <T, V, U> T getMapper(Class<T> mapperClass, V source, U customMapper) throws IllegalArgumentException {
        return Selma.getMapper(mapperClass, source == null ? null : Arrays.asList(source), customMapper == null ? null : Arrays.asList(customMapper));
    }

    private static synchronized <T, V, U> T getMapper(Class<T> mapperClass, List source, List customMappers) throws IllegalArgumentException {
        return Selma.getMapper(mapperClass, source, customMappers, true, null);
    }

    private static synchronized <T, V, U> T getMapper(Class<T> mapperClass, List source, List customMappers, boolean useCache, List factories) throws IllegalArgumentException {
        String mapperKey = String.format("%s-%s-%s-%s", mapperClass.getCanonicalName(), source, customMappers, factories);
        Object mapperInstance = mappers.get(mapperKey);
        if (mapperInstance == null || !mapperClass.isAssignableFrom(mapperInstance.getClass()) || !useCache) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = Selma.class.getClassLoader();
            }
            String generatedClassName = mapperClass.getCanonicalName() + "SelmaGeneratedClass";
            try {
                Class<?>[] classes;
                Class<?>[] interfaces;
                Class<?> classe;
                Method method;
                Class<?> mapperImpl = classLoader.loadClass(generatedClassName);
                Constructor<?> retainedConstructor = null;
                if (mapperImpl.getConstructors().length != 1) {
                    throw new IllegalArgumentException("Mapper class " + mapperImpl.toString() + " should have 1 constructor !");
                }
                retainedConstructor = mapperImpl.getConstructors()[0];
                if (source != null && retainedConstructor.getParameterTypes().length != source.size()) {
                    throw new IllegalArgumentException("Mapper class " + mapperImpl.toString() + " constructor needs a source " + retainedConstructor.toString());
                }
                mapperInstance = source != null && source.size() > 0 ? retainedConstructor.newInstance(source.toArray()) : mapperImpl.newInstance();
                if (factories != null) {
                    for (Object factory : factories) {
                        if (factory == null) continue;
                        Class<?> factoryClass = factory.getClass();
                        method = null;
                        classe = factoryClass;
                        while (method == null && !Object.class.equals(classe)) {
                            interfaces = classe.getInterfaces();
                            classes = Arrays.copyOf(interfaces, interfaces.length + 1);
                            classes[interfaces.length] = classe;
                            method = Selma.getSetFactoryMethodFor(generatedClassName, mapperImpl, factoryClass, classes);
                            classe = classe.getSuperclass();
                        }
                        if (method != null) {
                            method.invoke(mapperInstance, factory);
                            continue;
                        }
                        throw new IllegalArgumentException("given a Factory of type " + factoryClass.getSimpleName() + " while setter does not exist, add it to @Mapper interface");
                    }
                }
                if (customMappers != null) {
                    for (Object customMapper : customMappers) {
                        if (customMapper == null) continue;
                        Class<?> customMapperClass = customMapper.getClass();
                        method = null;
                        classe = customMapperClass;
                        while (method == null && !Object.class.equals(classe)) {
                            interfaces = classe.getInterfaces();
                            classes = Arrays.copyOf(interfaces, interfaces.length + 1);
                            classes[interfaces.length] = classe;
                            method = Selma.getSetCustomMapperMethodFor(generatedClassName, mapperImpl, customMapperClass, classes);
                            classe = classe.getSuperclass();
                        }
                        if (method != null) {
                            method.invoke(mapperInstance, customMapper);
                            continue;
                        }
                        throw new IllegalArgumentException("given a CustomMapper of type " + customMapperClass.getSimpleName() + " while setter does not exist, add it to @Mapper interface");
                    }
                }
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(String.format("Instantiation of Mapper class %s failed : %s", generatedClassName, e.getMessage()), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Instantiation of Mapper class %s failed : %s", generatedClassName, e.getMessage()), e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Unable to load generated mapper class %s failed : %s", generatedClassName, e.getMessage()), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Instantiation of Mapper class %s failed (No constructor with %s parameter !) : %s", generatedClassName, source.getClass().getSimpleName(), e.getMessage()), e);
            }
            if (useCache) {
                mappers.put(mapperKey, mapperInstance);
            }
            return (T)mapperInstance;
        }
        return (T)mapperInstance;
    }

    private static <T> Method getSetCustomMapperMethodFor(String generatedClassName, Class<T> mapperImpl, Class<?> customMapperClass, Class<?> ... classes) {
        Method method = null;
        for (Class<?> classe : classes) {
            String setter = SET_CUSTOM_MAPPER + classe.getSimpleName();
            try {
                method = mapperImpl.getMethod(setter, classe);
                break;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                throw new SelmaException(e, "Setter for custom mapper %s named %s not accessible in %s", customMapperClass, setter, generatedClassName);
            }
        }
        return method;
    }

    private static <T> Method getSetFactoryMethodFor(String generatedClassName, Class<T> mapperImpl, Class<?> factoryClass, Class<?> ... classes) {
        Method method = null;
        for (Class<?> classe : classes) {
            String setter = SET_FACTORY + classe.getSimpleName();
            try {
                method = mapperImpl.getMethod(setter, classe);
                break;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                throw new SelmaException(e, "Setter for custom mapper %s named %s not accessible in %s", factoryClass, setter, generatedClassName);
            }
        }
        return method;
    }

    public static class MapperBuilder<T> {
        private final Class<T> mapperClass;
        private final List customMappers;
        private final List sources;
        private final boolean cache;
        private final List factories;

        private MapperBuilder(Class<T> mapperClass) {
            this.mapperClass = mapperClass;
            this.customMappers = null;
            this.sources = null;
            this.cache = true;
            this.factories = null;
        }

        private MapperBuilder(Class<T> mapperClass, List sources, List customMappers, boolean cache, List factories) {
            this.mapperClass = mapperClass;
            this.sources = sources;
            this.customMappers = customMappers;
            this.cache = cache;
            this.factories = factories;
        }

        public T build() {
            Object res = Selma.getMapper(this.mapperClass, this.sources, this.customMappers, this.cache, this.factories);
            return (T)res;
        }

        public MapperBuilder<T> withCustom(Object ... customMapper) {
            return new MapperBuilder<T>(this.mapperClass, this.sources, Arrays.asList(customMapper), this.cache, this.factories);
        }

        public MapperBuilder<T> withSources(Object ... dataSource) {
            return new MapperBuilder<T>(this.mapperClass, Arrays.asList(dataSource), this.customMappers, this.cache, this.factories);
        }

        public MapperBuilder<T> disableCache() {
            return new MapperBuilder<T>(this.mapperClass, this.sources, this.customMappers, false, this.factories);
        }

        public MapperBuilder<T> withFactories(Object ... factories) {
            return new MapperBuilder<T>(this.mapperClass, this.sources, this.customMappers, this.cache, Arrays.asList(factories));
        }
    }
}

