/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.spring.elasticsearch.ElasticsearchAbstractClientFactoryBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Dictionary;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ElasticsearchTransportClientFactoryBean
extends ElasticsearchAbstractClientFactoryBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String[] esNodes = new String[]{"localhost:9300"};
    private String[] plugins = new String[0];

    public void setEsNodes(String[] esNodes) {
        this.esNodes = esNodes;
    }

    public void setPlugins(String[] plugins) {
        this.plugins = plugins;
    }

    @Override
    protected Client buildClient() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder();
        if (null != this.properties) {
            settingsBuilder.put((Dictionary)this.properties);
        }
        ArrayList<Class> pluginClasses = new ArrayList<Class>(this.plugins.length);
        for (String plugin : this.plugins) {
            this.logger.debug("Adding plugin [{}]", (Object)plugin);
            pluginClasses.add(ClassUtils.resolveClassName((String)plugin, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        PreBuiltTransportClient client = new PreBuiltTransportClient(settingsBuilder.build(), pluginClasses);
        for (String esNode : this.esNodes) {
            client.addTransportAddress((TransportAddress)this.toAddress(esNode));
        }
        return client;
    }

    private InetSocketTransportAddress toAddress(String address) throws UnknownHostException {
        if (address == null) {
            return null;
        }
        String[] splitted = address.split(":");
        int port = 9300;
        if (splitted.length > 1) {
            port = Integer.parseInt(splitted[1]);
        }
        return new InetSocketTransportAddress(InetAddress.getByName(splitted[0]), port);
    }
}

