/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.spring.elasticsearch.ElasticsearchAbstractFactoryBean;
import fr.pilato.spring.elasticsearch.proxy.GenericInvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ElasticsearchNodeFactoryBean
extends ElasticsearchAbstractFactoryBean
implements FactoryBean<Node>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Node node;
    private Node proxyfiedNode;

    public void afterPropertiesSet() throws Exception {
        if (this.async) {
            Assert.notNull((Object)this.taskExecutor);
            Future nodeFuture = this.taskExecutor.submit((Callable)new Callable<Node>(){

                @Override
                public Node call() throws Exception {
                    return ElasticsearchNodeFactoryBean.this.initialize();
                }
            });
            this.proxyfiedNode = (Node)Proxy.newProxyInstance(Node.class.getClassLoader(), new Class[]{Node.class}, new GenericInvocationHandler(nodeFuture));
        } else {
            this.node = this.initialize();
        }
    }

    public void destroy() throws Exception {
        try {
            this.logger.info((Object)("Closing ElasticSearch node " + this.node.settings().get("name")));
            this.node.close();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error closing Elasticsearch node: ", (Throwable)e);
        }
    }

    public Node getObject() throws Exception {
        return this.async ? this.proxyfiedNode : this.node;
    }

    public Class<Node> getObjectType() {
        return Node.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private Node initialize() {
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder();
        if (null != this.settings && null == this.properties) {
            this.logger.warn((Object)"settings has been deprecated in favor of properties. See issue #15: https://github.com/dadoonet/spring-elasticsearch/issues/15.");
            nodeBuilder.getSettings().put(this.settings);
        }
        if (null != this.settingsFile && null == this.properties) {
            Settings settings = ImmutableSettings.settingsBuilder().loadFromClasspath(this.settingsFile).build();
            nodeBuilder.getSettings().put(settings);
        }
        if (null != this.properties) {
            nodeBuilder.getSettings().put(this.properties);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Starting ElasticSearch node...");
        }
        this.node = nodeBuilder.node();
        this.logger.info((Object)("Node [" + this.node.settings().get("name") + "] for [" + this.node.settings().get("cluster.name") + "] cluster started..."));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  - data : " + this.node.settings().get("path.data")));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  - logs : " + this.node.settings().get("path.logs")));
        }
        return this.node;
    }
}

