/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.xhtml;

import fr.opensagres.xdocreport.utils.BorderType;
import fr.opensagres.xdocreport.utils.StringUtils;
import fr.opensagres.xdocreport.xhtml.extension.CSSStylePropertyConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLUtil;
import java.math.BigInteger;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.converter.internal.XWPFRunUtils;
import org.apache.poi.xwpf.converter.internal.XWPFUtils;
import org.apache.poi.xwpf.converter.internal.itext.TableWidth;
import org.apache.poi.xwpf.converter.internal.itext.XWPFParagraphUtils;
import org.apache.poi.xwpf.converter.internal.itext.XWPFTableUtil;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;

public class XHTMLStyleUtil
implements CSSStylePropertyConstants {
    public static StringBuilder getStyle(XWPFDocument document, CTDocDefaults defaults) {
        CTPageMar pageMargin;
        StringBuilder htmlStyle = new StringBuilder();
        CTSectPr sectPr = document.getDocument().getBody().getSectPr();
        CTPageSz pageSize = sectPr.getPgSz();
        if (pageSize != null) {
            BigInteger width = pageSize.getW();
            float widthPt = DxaUtil.dxa2points(width);
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"width", (String)(widthPt + "pt"));
        }
        if ((pageMargin = sectPr.getPgMar()) != null) {
            BigInteger marginLeft;
            BigInteger marginRight;
            BigInteger marginTop;
            BigInteger marginBottom = pageMargin.getBottom();
            if (marginBottom != null) {
                float marginBottomPt = DxaUtil.dxa2points(marginBottom);
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-bottom", (String)(marginBottomPt + "pt"));
            }
            if ((marginTop = pageMargin.getTop()) != null) {
                float marginTopPt = DxaUtil.dxa2points(marginTop);
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-top", (String)(marginTopPt + "pt"));
            }
            if ((marginRight = pageMargin.getRight()) != null) {
                float marginRightPt = DxaUtil.dxa2points(marginRight);
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-right", (String)(marginRightPt + "pt"));
            }
            if ((marginLeft = pageMargin.getLeft()) != null) {
                float marginLeftPt = DxaUtil.dxa2points(marginLeft);
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-left", (String)(marginLeftPt + "pt"));
            }
        }
        return htmlStyle;
    }

    public static StringBuilder getStyle(XWPFParagraph paragraph, XWPFStyle style, CTDocDefaults defaults) {
        StringBuilder htmlStyle = new StringBuilder();
        float indentationLeft = -1.0f;
        float indentationRight = -1.0f;
        float firstLineIndent = -1.0f;
        float spacingBefore = -1.0f;
        float spacingAfter = -1.0f;
        if (indentationLeft == -1.0f && paragraph.getIndentationLeft() != -1) {
            indentationLeft = DxaUtil.dxa2points(paragraph.getIndentationLeft());
        }
        if (indentationRight == -1.0f && paragraph.getIndentationRight() != -1) {
            indentationRight = DxaUtil.dxa2points(paragraph.getIndentationRight());
        }
        if (firstLineIndent == -1.0f && paragraph.getIndentationFirstLine() != -1) {
            firstLineIndent = DxaUtil.dxa2points(paragraph.getIndentationFirstLine());
        }
        if (spacingBefore == -1.0f && paragraph.getSpacingBefore() != -1) {
            spacingBefore = DxaUtil.dxa2points(paragraph.getSpacingBefore());
        }
        if (spacingAfter == -1.0f && paragraph.getSpacingAfter() != -1) {
            spacingAfter = DxaUtil.dxa2points(paragraph.getSpacingAfter());
        }
        if (indentationLeft != -1.0f) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-align", (String)"left");
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-indent", (String)(indentationLeft + "pt"));
        }
        if (indentationRight != -1.0f) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-align", (String)"right");
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-indent", (String)(indentationRight + "pt"));
        }
        if (firstLineIndent != -1.0f) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-indent", (String)(firstLineIndent + "pt"));
        }
        ParagraphAlignment alignment = paragraph.getAlignment();
        switch (alignment) {
            case LEFT: {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-align", (String)"left");
                break;
            }
            case RIGHT: {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-align", (String)"right");
                break;
            }
            case CENTER: {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-align", (String)"center");
                break;
            }
            case BOTH: {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-align", (String)"justified");
            }
        }
        if (spacingBefore != -1.0f) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-top", (String)(spacingBefore + "pt"));
        } else {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-top", (String)"0");
        }
        if (spacingAfter != -1.0f) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-bottom", (String)(spacingAfter + "pt"));
        } else {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"margin-bottom", (String)"0");
        }
        String backgroundColor = XWPFParagraphUtils.getBackgroundColor(paragraph);
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"background-color", (String)("#" + backgroundColor));
        }
        return htmlStyle;
    }

    public static StringBuilder getStyle(XWPFRun run, XWPFStyle runStyle, XWPFStyle style, CTDocDefaults defaults) {
        String fontColor;
        float fontSize;
        CTRPr rprDefault;
        StringBuilder htmlStyle = new StringBuilder();
        CTRPr runRprStyle = XWPFUtils.getRPr(runStyle);
        CTRPr rprStyle = XWPFUtils.getRPr(style);
        String fontFamily = XWPFRunUtils.getFontFamily(run, rprStyle, rprDefault = XWPFUtils.getRPr(defaults));
        if (StringUtils.isNotEmpty((String)fontFamily)) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"font-family", (String)("'" + fontFamily + "'"));
        }
        if ((fontSize = (float)run.getFontSize()) == -1.0f) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"font-size", (String)(fontSize + "pt"));
        }
        if (XWPFRunUtils.isBold(run, runRprStyle, rprStyle, rprDefault)) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"font-weight", (String)"bold");
        }
        if (XWPFRunUtils.isItalic(run, runRprStyle, rprStyle, rprDefault)) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"font-style", (String)"italic");
        }
        if (StringUtils.isNotEmpty((String)(fontColor = XWPFRunUtils.getFontColor(run, runRprStyle, rprStyle, rprDefault)))) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"color", (String)("#" + fontColor));
        }
        UnderlinePatterns underlinePatterns = run.getUnderline();
        switch (underlinePatterns) {
            case SINGLE: {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"text-decoration", (String)"underline");
                break;
            }
        }
        return htmlStyle;
    }

    private static void setBorders(CTTblBorders localTblBorders, CTTblBorders styleTblBorders, StringBuilder htmlStyle) {
        XHTMLStyleUtil.setBorder(localTblBorders != null ? localTblBorders.getTop() : null, styleTblBorders != null ? styleTblBorders.getTop() : null, htmlStyle, BorderType.TOP);
    }

    private static void setBorder(CTBorder localBorder, CTBorder styleBorder, StringBuilder htmlStyle, BorderType borderType) {
        BigInteger size;
        boolean noBorder = false;
        float borderSize = -1.0f;
        String borderColor = null;
        if (localBorder != null) {
            boolean bl = noBorder = STBorder.NONE == localBorder.getVal();
            if (noBorder) {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"border", (String)"none");
                return;
            }
            size = localBorder.getSz();
            if (size != null) {
                borderSize = DxaUtil.dxa2points(size);
            }
            borderColor = XWPFTableUtil.getBorderColor(localBorder);
        }
        if (styleBorder != null) {
            boolean bl = noBorder = STBorder.NONE == styleBorder.getVal();
            if (noBorder) {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"border", (String)"none");
                return;
            }
            if (borderSize == -1.0f && (size = styleBorder.getSz()) != null) {
                borderSize = DxaUtil.dxa2points(size);
            }
            if (borderColor == null) {
                borderColor = XWPFTableUtil.getBorderColor(styleBorder);
            }
        }
        if (borderSize != -1.0f) {
            switch (borderType) {
                case TOP: {
                    XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"border-top-width", (String)(borderSize + "pt"));
                }
            }
        }
        if (borderColor != null) {
            switch (borderType) {
                case TOP: {
                    XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"border-top-color", (String)("#" + borderColor));
                }
            }
        }
    }

    public static StringBuilder getStyle(XWPFTableCell tableCell, CTDocDefaults defaults) {
        String backgroundColor;
        CTShd shd;
        StringBuilder htmlStyle = new StringBuilder();
        CTTcPr tcPr = tableCell.getCTTc().getTcPr();
        CTTblWidth tblWidth = tcPr.getTcW();
        if (tblWidth != null) {
            TableWidth tableWidth = XWPFTableUtil.getTableWidth(tableCell);
            boolean percentUnit = tableWidth.percentUnit;
            if (percentUnit) {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"width", (String)(tableWidth.width + "%"));
            } else {
                XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"width", (String)(tableWidth.width + "pt"));
            }
        }
        if ((shd = tcPr.getShd()) != null && StringUtils.isNotEmpty((String)(backgroundColor = XWPFUtils.getColor(shd.xgetFill())))) {
            XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"background-color", (String)("#" + backgroundColor));
        }
        return htmlStyle;
    }

    public static CTPPr getPPr(XWPFStyle style) {
        if (style == null) {
            return null;
        }
        CTStyle ctStyle = style.getCTStyle();
        if (ctStyle == null) {
            return null;
        }
        return ctStyle.getPPr();
    }

    public static StringBuilder getStyle(XWPFPicture picture) {
        StringBuilder htmlStyle = new StringBuilder();
        CTPositiveSize2D ext = picture.getCTPicture().getSpPr().getXfrm().getExt();
        long x = ext.getCx();
        long y = ext.getCy();
        float width = DxaUtil.dxa2points(x) / 635.0f;
        float height = DxaUtil.dxa2points(y) / 635.0f;
        XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"width", (String)(width + "pt"));
        XHTMLUtil.addHTMLStyle((StringBuilder)htmlStyle, (String)"height", (String)(height + "pt"));
        return htmlStyle;
    }
}

