/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import java.awt.Color;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableFactory;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StyleUtils;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleBorder;
import org.apache.poi.xwpf.converter.internal.itext.styles.StylePadding;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableCellProperties;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableRowProperties;

public class StylableTableCell
extends PdfPCell
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private final IStylableFactory ownerDocument;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableTableCell(IStylableFactory ownerDocument, IStylableContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public void addElement(Element element) {
        super.addElement(element);
    }

    public void applyStyles(Object ele, Style style) {
        StyleTableCellProperties tableCellProperties;
        Float rowHeight;
        this.lastStyleApplied = style;
        StyleTableRowProperties tableRowProperties = style.getTableRowProperties();
        if (tableRowProperties != null && (rowHeight = tableRowProperties.getRowHeight()) != null) {
            super.setFixedHeight(rowHeight.floatValue());
        }
        if ((tableCellProperties = style.getTableCellProperties()) != null) {
            int verticalAlignment;
            Color backgroundColor = tableCellProperties.getBackgroundColor();
            if (backgroundColor != null) {
                super.setBackgroundColor(backgroundColor);
            }
            StyleBorder border = tableCellProperties.getBorder();
            StyleUtils.applyStyles(border, this);
            StyleBorder borderTop = tableCellProperties.getBorderTop();
            StyleUtils.applyStyles(borderTop, this);
            StyleBorder borderBottom = tableCellProperties.getBorderBottom();
            StyleUtils.applyStyles(borderBottom, this);
            StyleBorder borderLeft = tableCellProperties.getBorderLeft();
            StyleUtils.applyStyles(borderLeft, this);
            StyleBorder borderRight = tableCellProperties.getBorderRight();
            StyleUtils.applyStyles(borderRight, this);
            StylePadding padding = tableCellProperties.getPadding();
            if (padding != null) {
                if (padding.getPadding() != null) {
                    super.setPadding(padding.getPadding().floatValue());
                }
                if (padding.getPaddingTop() != null) {
                    super.setPaddingTop(padding.getPaddingTop().floatValue());
                }
                if (padding.getPaddingBottom() != null) {
                    super.setPaddingBottom(padding.getPaddingBottom().floatValue());
                }
                if (padding.getPaddingRight() != null) {
                    super.setPaddingRight(padding.getPaddingRight().floatValue());
                }
                if (padding.getPaddingLeft() != null) {
                    super.setPaddingLeft(padding.getPaddingLeft().floatValue());
                }
            }
            if ((verticalAlignment = tableCellProperties.getVerticalAlignment()) != -1) {
                super.setVerticalAlignment(verticalAlignment);
            }
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this;
    }

    public IITextContainer getITextContainer() {
        return this.parent;
    }

    public void setITextContainer(IITextContainer container) {
    }
}

