/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Element;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableDocument;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTableProperties;

public class StylableTable
extends ExtendedPdfPTable
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private final StylableDocument ownerDocument;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableTable(StylableDocument ownerDocument, IStylableContainer parent, int numColumns) {
        super(numColumns);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public void applyStyles(Object ele, Style style) {
        this.lastStyleApplied = style;
        StyleTableProperties tableProperties = style.getTableProperties();
        if (tableProperties != null && tableProperties.getWidth() != null) {
            super.setTotalWidth(tableProperties.getWidth().floatValue());
            super.setLockedWidth(true);
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public Element getElement() {
        return this;
    }
}

