/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Anchor;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableFactory;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTextProperties;

public class StylableAnchor
extends Anchor
implements IStylableContainer {
    private final IStylableFactory ownerDocument;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableAnchor(IStylableFactory ownerDocument, IStylableContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public void addElement(Element element) {
        super.add((Object)element);
    }

    public void applyStyles(Object ele, Style style) {
        Font font;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            super.setFont(font);
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this;
    }

    public IITextContainer getITextContainer() {
        return this.parent;
    }

    public void setITextContainer(IITextContainer container) {
    }
}

