/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal;

import org.apache.poi.xwpf.converter.internal.XWPFUtils;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public class XWPFRunUtils {
    public static String getFontFamily(XWPFRun run, CTRPr rprStyle, CTRPr rprDefault) {
        String fontFamily = run.getFontFamily();
        if (fontFamily == null) {
            CTFonts fonts;
            if (rprStyle != null && (fonts = rprStyle.getRFonts()) != null) {
                fontFamily = fonts.getAscii();
            }
            if (fontFamily == null && rprDefault != null && (fonts = rprDefault.getRFonts()) != null) {
                fontFamily = fonts.getAscii();
            }
        }
        return fontFamily;
    }

    public static String getFontColor(XWPFRun run, CTRPr runRprStyle, CTRPr rprStyle, CTRPr rprDefault) {
        CTRPr rPr = run.getCTR().getRPr();
        String fontColor = XWPFRunUtils.getColor(rPr);
        if (fontColor == null && (fontColor = XWPFRunUtils.getColor(runRprStyle)) == null && (fontColor = XWPFRunUtils.getColor(rprStyle)) == null) {
            fontColor = XWPFRunUtils.getColor(rprDefault);
        }
        return fontColor;
    }

    public static String getColor(CTRPr rPr) {
        CTColor ctColor;
        if (rPr != null && (ctColor = rPr.getColor()) != null) {
            STHexColor color = ctColor.xgetVal();
            return XWPFUtils.getColor(color);
        }
        return null;
    }

    public static boolean isBold(XWPFRun run, CTRPr runRprStyle, CTRPr rprStyle, CTRPr rprDefault) {
        Boolean bold = XWPFRunUtils.isBold(run.getCTR().getRPr());
        if (bold != null) {
            return bold;
        }
        bold = XWPFRunUtils.isBold(runRprStyle);
        if (bold != null) {
            return bold;
        }
        bold = XWPFRunUtils.isBold(rprStyle);
        if (bold != null) {
            return bold;
        }
        bold = XWPFRunUtils.isBold(rprDefault);
        if (bold != null) {
            return bold;
        }
        return run.isBold();
    }

    private static Boolean isBold(CTRPr pr) {
        if (pr == null || !pr.isSetB()) {
            return null;
        }
        return XWPFRunUtils.isCTOnOff(pr.getB());
    }

    public static boolean isItalic(XWPFRun run, CTRPr runRprStyle, CTRPr rprStyle, CTRPr rprDefault) {
        Boolean italic = XWPFRunUtils.isItalic(run.getCTR().getRPr());
        if (italic != null) {
            return italic;
        }
        italic = XWPFRunUtils.isItalic(runRprStyle);
        if (italic != null) {
            return italic;
        }
        italic = XWPFRunUtils.isItalic(rprStyle);
        if (italic != null) {
            return italic;
        }
        italic = XWPFRunUtils.isItalic(rprDefault);
        if (italic != null) {
            return italic;
        }
        return run.isItalic();
    }

    private static Boolean isItalic(CTRPr pr) {
        if (pr == null || !pr.isSetI()) {
            return null;
        }
        return XWPFRunUtils.isCTOnOff(pr.getI());
    }

    private static boolean isCTOnOff(CTOnOff onoff) {
        if (!onoff.isSetVal()) {
            return true;
        }
        if (onoff.getVal() == STOnOff.ON) {
            return true;
        }
        return onoff.getVal() == STOnOff.TRUE;
    }

    public static CTString getRStyle(XWPFRun run) {
        if (run == null) {
            return null;
        }
        CTR ctr = run.getCTR();
        if (ctr == null) {
            return null;
        }
        CTRPr rpr = ctr.getRPr();
        if (rpr == null) {
            return null;
        }
        return rpr.getRStyle();
    }
}

