/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.xhtml;

import fr.opensagres.xdocreport.utils.StringEscapeUtils;
import fr.opensagres.xdocreport.utils.StringUtils;
import fr.opensagres.xdocreport.xhtml.extension.CSSStylePropertyConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPageContentBuffer;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.xwpf.converter.IURIResolver;
import org.apache.poi.xwpf.converter.internal.XWPFElementVisitor;
import org.apache.poi.xwpf.converter.internal.XWPFRunUtils;
import org.apache.poi.xwpf.converter.internal.itext.XWPFPictureUtil;
import org.apache.poi.xwpf.converter.internal.xhtml.POIXHTMLPage;
import org.apache.poi.xwpf.converter.internal.xhtml.StyleEngineForXHTML;
import org.apache.poi.xwpf.converter.internal.xhtml.XHTMLStyleUtil;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLMapper
extends XWPFElementVisitor<XHTMLPageContentBuffer>
implements XHTMLConstants,
CSSStylePropertyConstants {
    private static final String WORD_MEDIA = "word/media/";
    private static final Logger LOG = LoggerFactory.getLogger(XHTMLMapper.class);
    private POIXHTMLPage xhtml = null;
    private final IURIResolver resolver;
    private final int indent;
    private StyleEngineForXHTML styleEngine;
    protected OutputStream out;

    public XHTMLMapper(XWPFDocument document, int indent, IURIResolver resolver) {
        super(document);
        this.resolver = resolver;
        this.indent = indent;
        this.styleEngine = new StyleEngineForXHTML(document, false, indent, resolver);
    }

    @Override
    protected XHTMLPageContentBuffer startVisitDocument(OutputStream out) throws Exception {
        this.xhtml = new POIXHTMLPage(this.styleEngine, this.indent);
        this.out = out;
        this.xhtml.getPageBodyContentBody().startElementNotEnclosed("div");
        StringBuilder htmlStyle = XHTMLStyleUtil.getStyle(this.document, this.defaults);
        this.setAttributStyleIfNeeded((XHTMLPageContentBuffer)this.xhtml.getPageBodyContentBody(), htmlStyle);
        this.xhtml.getPageBodyContentBody().endElementNotEnclosed();
        return this.xhtml.getPageBodyContentBody();
    }

    @Override
    protected void endVisitDocument() throws Exception {
        this.xhtml.getPageBodyContentBody().endElement("div");
        this.xhtml.save(this.out);
    }

    @Override
    protected XHTMLPageContentBuffer startVisitPargraph(XWPFParagraph paragraph, XHTMLPageContentBuffer parentContainer) throws Exception {
        this.styleEngine.startVisitPargraph(paragraph, null);
        parentContainer.startElementNotEnclosed("p");
        if (paragraph.getStyleID() != null) {
            LOG.debug(paragraph.getStyleID());
            parentContainer.setAttribute("class", paragraph.getStyleID());
        }
        StringBuilder htmlStyle = XHTMLStyleUtil.getStyle(paragraph, super.getXWPFStyle(paragraph.getStyleID()), this.defaults);
        this.setAttributStyleIfNeeded(parentContainer, htmlStyle);
        parentContainer.endElementNotEnclosed();
        return parentContainer;
    }

    @Override
    protected void endVisitPargraph(XWPFParagraph paragraph, XHTMLPageContentBuffer parentContainer, XHTMLPageContentBuffer paragraphContainer) throws Exception {
        paragraphContainer.endElement("p");
    }

    @Override
    protected void visitEmptyRun(XHTMLPageContentBuffer paragraphContainer) throws Exception {
        paragraphContainer.startEndElement("br");
    }

    @Override
    protected void visitRun(XWPFRun run, XHTMLPageContentBuffer paragraphContainer) throws Exception {
        CTString rStyle = XWPFRunUtils.getRStyle(run);
        XWPFStyle runStyle = super.getXWPFStyle(rStyle != null ? rStyle.getVal() : null);
        StringBuilder htmlStyle = XHTMLStyleUtil.getStyle(run, runStyle, super.getXWPFStyle(run.getParagraph().getStyle()), this.defaults);
        List brs = run.getCTR().getBrList();
        for (CTBr br : brs) {
            paragraphContainer.startEndElement("br");
        }
        List texts = run.getCTR().getTList();
        for (CTText ctText : texts) {
            paragraphContainer.startElementNotEnclosed("span");
            this.setAttributStyleIfNeeded(paragraphContainer, htmlStyle);
            paragraphContainer.endElementNotEnclosed();
            paragraphContainer.setText(StringEscapeUtils.escapeHtml((String)ctText.getStringValue()));
            paragraphContainer.endElement("span");
        }
        super.visitPictures(run, paragraphContainer);
    }

    @Override
    protected XHTMLPageContentBuffer startVisitTable(XWPFTable table, XHTMLPageContentBuffer tableContainer) throws Exception {
        tableContainer.startElementNotEnclosed("table");
        tableContainer.endElementNotEnclosed();
        return tableContainer;
    }

    @Override
    protected void visitTableRow(XWPFTableRow row, XHTMLPageContentBuffer tableContainer) throws Exception {
        tableContainer.startElementNotEnclosed("tr");
        tableContainer.endElementNotEnclosed();
        super.visitTableRow(row, tableContainer);
        tableContainer.endElement("tr");
    }

    @Override
    protected XHTMLPageContentBuffer startVisitTableCell(XWPFTableCell tableCell, XHTMLPageContentBuffer tableContainer) {
        tableContainer.startElementNotEnclosed("td");
        CTTcPr tcPr = tableCell.getCTTc().getTcPr();
        Integer colspan = null;
        CTDecimalNumber gridSpan = tcPr.getGridSpan();
        if (gridSpan != null) {
            colspan = gridSpan.getVal().intValue();
        }
        if (colspan != null) {
            tableContainer.setAttribute("colspan", colspan);
        }
        StringBuilder htmlStyle = XHTMLStyleUtil.getStyle(tableCell, this.defaults);
        this.setAttributStyleIfNeeded(tableContainer, htmlStyle);
        tableContainer.endElementNotEnclosed();
        return tableContainer;
    }

    @Override
    protected void endVisitTableCell(XWPFTableCell cell, XHTMLPageContentBuffer tableContainer, XHTMLPageContentBuffer tableCellContainer) {
        tableContainer.endElement("td");
    }

    @Override
    protected void endVisitTable(XWPFTable table, XHTMLPageContentBuffer parentContainer, XHTMLPageContentBuffer tableContainer) throws Exception {
        tableContainer.endElement("table");
    }

    @Override
    protected void visitPicture(XWPFPicture picture, XHTMLPageContentBuffer parentContainer) throws Exception {
        String src;
        parentContainer.startElementNotEnclosed("img");
        CTPicture ctPic = picture.getCTPicture();
        String blipId = ctPic.getBlipFill().getBlip().getEmbed();
        XWPFPictureData pictureData = XWPFPictureUtil.getPictureData(this.document, blipId);
        if (pictureData != null && StringUtils.isNotEmpty((String)(src = pictureData.getFileName()))) {
            src = this.resolver.resolve(WORD_MEDIA + src);
            parentContainer.setAttribute("src", src);
        }
        StringBuilder htmlStyle = XHTMLStyleUtil.getStyle(picture);
        this.setAttributStyleIfNeeded(parentContainer, htmlStyle);
        parentContainer.endElementNotEnclosed();
        parentContainer.endElement("img");
    }

    private void setAttributStyleIfNeeded(XHTMLPageContentBuffer buffer, StringBuilder htmlStyle) {
        if (htmlStyle.length() > 0) {
            buffer.setAttribute("style", htmlStyle.toString());
        }
    }

    @Override
    protected void visitHeader(CTHdrFtrRef headerRef) throws Exception {
    }

    @Override
    protected void visitFooter(CTHdrFtrRef footerRef) throws Exception {
    }
}

