/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.xhtml;

import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.utils.StringUtils;
import fr.opensagres.xdocreport.xhtml.extension.CSSStylePropertyConstants;
import fr.opensagres.xdocreport.xhtml.extension.CSSStyleSheet;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPageContentBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.converter.IURIResolver;
import org.apache.poi.xwpf.converter.internal.AbstractStyleEngine;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public class StyleEngineForXHTML
extends AbstractStyleEngine
implements XHTMLConstants,
CSSStylePropertyConstants {
    private static final String STYLE_NAME_HEADER = "Header";
    private static final String STYLE_NAME_FOOTER = "Footer";
    private CSSStyleSheet cssStyleSheet;
    private final boolean generateCSSComments;
    private static final String DEFAULT_STYLE = "default";
    private final IURIResolver resolver;
    private final List<String> stylesMap = new ArrayList<String>();

    public StyleEngineForXHTML(XWPFDocument document, boolean generateCSSComments, int indent, IURIResolver resolver) {
        super(document);
        this.generateCSSComments = generateCSSComments;
        this.resolver = resolver;
        this.cssStyleSheet = new CSSStyleSheet(indent);
        this.buildDefault();
    }

    private void maptStyleParagraphProperties(CTPPr xwpfParagraphProperties) {
        CTInd ctInd;
        CTTextAlignment alignment;
        CTSpacing spacing = xwpfParagraphProperties.getSpacing();
        if (spacing != null) {
            BigInteger spacingAfter;
            BigInteger spacingBefore = spacing.getBefore();
            if (spacingBefore != null) {
                this.cssStyleSheet.setCSSProperty("margin-top", DxaUtil.dxa2points(spacingBefore) + "pt");
            }
            if ((spacingAfter = spacing.getAfter()) != null) {
                this.cssStyleSheet.setCSSProperty("margin-bottom", DxaUtil.dxa2points(spacingAfter) + "pt");
            }
        }
        if ((alignment = xwpfParagraphProperties.getTextAlignment()) != null) {
            STTextAlignment textAlignment = alignment.xgetVal();
            this.cssStyleSheet.setCSSProperty("vertical-align", textAlignment.getStringValue());
        }
        if ((ctInd = xwpfParagraphProperties.getInd()) != null) {
            BigInteger right;
            BigInteger left;
            BigInteger firstLine = ctInd.getFirstLine();
            if (firstLine != null) {
                this.cssStyleSheet.setCSSProperty("text-indent", DxaUtil.dxa2points(firstLine) + "pt");
            }
            if ((left = ctInd.getLeft()) != null) {
                this.cssStyleSheet.setCSSProperty("margin-left", DxaUtil.dxa2points(left) + "pt");
            }
            if ((right = ctInd.getLeft()) != null) {
                this.cssStyleSheet.setCSSProperty("margin-right", DxaUtil.dxa2points(right) + "pt");
            }
        }
    }

    private void processRPR(CTRPr ctParaRPr) {
        STHexColor hexColor;
        String strText;
        CTColor ctColor;
        STUnderline uu;
        CTUnderline underline;
        CTFonts fonts = ctParaRPr.getRFonts();
        if (fonts != null) {
            String fontFamily = fonts.getAscii();
            if (StringUtils.isNotEmpty((String)fontFamily)) {
                this.cssStyleSheet.setCSSProperty("font-family", "\"" + fontFamily + "\"");
            }
        } else if (ctParaRPr.getB() != null && STOnOff.TRUE.equals(ctParaRPr.getB().xgetVal())) {
            this.cssStyleSheet.setCSSProperty("font-weight", "bold");
        } else if (ctParaRPr.getI() != null && STOnOff.TRUE.equals(ctParaRPr.getI().xgetVal())) {
            this.cssStyleSheet.setCSSProperty("font-style", "italic");
        }
        CTHpsMeasure hpsMeasure = ctParaRPr.getSz();
        if (hpsMeasure != null) {
            STHpsMeasure measure = hpsMeasure.xgetVal();
            float size = measure.getBigDecimalValue().floatValue();
            this.cssStyleSheet.setCSSProperty("font-size", String.valueOf(size));
        }
        if ((underline = ctParaRPr.getU()) != null && STUnderline.NONE != (uu = underline.xgetVal()).enumValue()) {
            this.cssStyleSheet.setCSSProperty("text-decoration", "underline");
        }
        if ((ctColor = ctParaRPr.getColor()) != null && !"auto".equals(strText = (hexColor = ctColor.xgetVal()).getStringValue())) {
            this.cssStyleSheet.setCSSProperty("color", "#" + strText);
        }
    }

    private void buildDefault() {
        try {
            CTDocDefaults defaults = this.document.getStyle().getDocDefaults();
            this.stylesMap.add(DEFAULT_STYLE);
            this.cssStyleSheet.startCSSStyleDeclaration(DEFAULT_STYLE);
            if (defaults != null && defaults.getPPrDefault().getPPr() != null) {
                this.maptStyleParagraphProperties(defaults.getPPrDefault().getPPr());
            }
            this.cssStyleSheet.endCSSStyleDeclaration();
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String buildStyle(String styleID) {
        if (styleID == null) {
            return DEFAULT_STYLE;
        }
        if (!this.stylesMap.contains(styleID)) {
            XWPFStyle style = this.document.getStyles().getStyle(styleID);
            CTPPr xwpfParagraphProperties = style.getCTStyle().getPPr();
            if (xwpfParagraphProperties != null) {
                this.cssStyleSheet.startCSSStyleDeclaration(styleID);
                this.maptStyleParagraphProperties(xwpfParagraphProperties);
                CTStyle ctStyle = style.getCTStyle();
                CTRPr rpr = ctStyle.getRPr();
                this.processRPR(rpr);
                CTPBdr borders = xwpfParagraphProperties.getPBdr();
                if (borders != null) {
                    CTBorder right;
                    CTBorder top;
                    CTBorder left;
                    CTBorder bottom = borders.getBottom();
                    if (bottom != null) {
                        STBorder border = bottom.xgetVal();
                        System.err.println("bottom " + border);
                        if (!STBorder.NONE.equals(border) && !STBorder.NIL.equals(border)) {
                            this.cssStyleSheet.setCSSProperty("border-bottom", border.getStringValue());
                            this.cssStyleSheet.setCSSProperty("border-bottom-width", bottom.getSz().floatValue() / 2.0f + "pt");
                            this.cssStyleSheet.setCSSProperty("border-bottom-color", "#" + bottom.xgetColor().getStringValue());
                        }
                    }
                    if ((left = borders.getBottom()) != null) {
                        STBorder border = left.xgetVal();
                        System.err.println("left " + border.getStringValue());
                        if (!STBorder.NONE.equals(border) && !STBorder.NIL.equals(border)) {
                            this.cssStyleSheet.setCSSProperty("border-left", border.getStringValue());
                            this.cssStyleSheet.setCSSProperty("border-left-width", left.getSz().floatValue() / 2.0f + "pt");
                            this.cssStyleSheet.setCSSProperty("border-left-color", "#" + left.xgetColor().getStringValue());
                        }
                    }
                    if ((top = borders.getBottom()) != null) {
                        STBorder border = left.xgetVal();
                        System.err.println("top " + border.getStringValue());
                        if (!STBorder.NONE.equals(border) && !STBorder.NIL.equals(border)) {
                            this.cssStyleSheet.setCSSProperty("border-top", border.getStringValue());
                            this.cssStyleSheet.setCSSProperty("border-top-width", top.getSz().floatValue() / 2.0f + "pt");
                            this.cssStyleSheet.setCSSProperty("border-top-color", "#" + top.xgetColor().getStringValue());
                        }
                    }
                    if ((right = borders.getBottom()) != null) {
                        STBorder border = right.xgetVal();
                        System.err.println("right " + border.getStringValue());
                        if (!STBorder.NONE.equals(border) && !STBorder.NIL.equals(border)) {
                            this.cssStyleSheet.setCSSProperty("border-right", border.getStringValue());
                            this.cssStyleSheet.setCSSProperty("border-right-width", right.getSz().floatValue() / 2.0f + "pt");
                            this.cssStyleSheet.setCSSProperty("border-right-color", "#" + right.xgetColor().getStringValue());
                        }
                    }
                }
                this.cssStyleSheet.endCSSStyleDeclaration();
            }
            this.stylesMap.add(styleID);
        }
        return styleID;
    }

    protected IITextContainer startVisitDocument(OutputStream out) throws Exception {
        CTStyles styles = this.document.getStyle();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:styles begin");
        }
        styles.getDocDefaults().getPPrDefault().getPPr();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:styles end");
        }
        return null;
    }

    protected IITextContainer startVisitPargraph(XWPFParagraph xwpfParagraph, IITextContainer pdfParagraph) throws Exception {
        String styleID = xwpfParagraph.getStyleID();
        if (styleID != null && !this.stylesMap.contains(styleID)) {
            this.buildStyle(styleID);
        }
        return pdfParagraph;
    }

    protected void endVisitPargraph(XWPFParagraph paragraph, IITextContainer parentContainer, IITextContainer paragraphContainer) throws Exception {
    }

    protected void visitEmptyRun(IITextContainer paragraphContainer) throws Exception {
    }

    protected void visitRun(XWPFRun run, IITextContainer paragraphContainer) throws Exception {
    }

    protected IITextContainer startVisitTable(XWPFTable table, IITextContainer tableContainer) throws Exception {
        return null;
    }

    protected void endVisitTable(XWPFTable table, IITextContainer parentContainer, IITextContainer tableContainer) throws Exception {
    }

    protected IITextContainer startVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer) {
        return null;
    }

    protected void endVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer, IITextContainer tableCellContainer) {
        System.out.println(cell);
    }

    protected void visitPicture(XWPFPicture picture, IITextContainer parentContainer) throws Exception {
    }

    protected void endVisitDocument() throws Exception {
    }

    protected void visitHeader(CTHdrFtrRef headerRef) throws Exception {
    }

    protected void visitFooter(CTHdrFtrRef footerRef) throws Exception {
    }

    public String getClassName(String familyName, String styleName) {
        StringBuilder className = new StringBuilder();
        className.append(familyName);
        if (styleName != null) {
            className.append('_');
            className.append(StringUtils.replaceAll((String)styleName, (String)".", (String)"_"));
        }
        return className.toString();
    }

    public CSSStyleSheet getCSSStyleSheet() {
        return this.cssStyleSheet;
    }

    public String getMasterPageHeaderStyleName(String masterPageLayoutName) {
        return masterPageLayoutName + STYLE_NAME_HEADER;
    }

    public String getMasterPageFooterStyleName(String masterPageLayoutName) {
        return masterPageLayoutName + STYLE_NAME_FOOTER;
    }

    public void applyStyles(String styleName, XHTMLPageContentBuffer xhtml) {
        if (StringUtils.isNotEmpty((String)styleName)) {
            xhtml.setAttribute("class", styleName);
        }
    }

    public IURIResolver getURIResolver() {
        return this.resolver;
    }

    public void visit(Object ele) {
    }
}

