/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.styles;

import java.math.BigInteger;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.converter.internal.itext.styles.FontInfos;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleBorder;

public class StyleParagraphProperties {
    private StyleBorder borderTop;
    private StyleBorder borderBottom;
    private StyleBorder borderLeft;
    private StyleBorder borderRight;
    private int alignment = -1;
    private int verticalAlignment = -1;
    private Float lineHeight;
    private int indentationFirstLine;
    private int indentationLeft;
    private int indentationRight;
    private int spacingAfter;
    private int spacingBefore;
    private FontInfos fontInfos;

    public StyleParagraphProperties() {
    }

    public StyleParagraphProperties(StyleParagraphProperties paragraphProperties) {
        if (paragraphProperties == null) {
            return;
        }
    }

    public int getSpacingAfter() {
        return this.spacingAfter;
    }

    public void setSpacingAfter(int spacingAfter) {
        this.spacingAfter = DxaUtil.dxa2points(spacingAfter);
    }

    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    public void setSpacingBefore(int spacingBefore) {
        this.spacingBefore = DxaUtil.dxa2points(spacingBefore);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public Float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(Float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public int getIndentationFirstLine() {
        return this.indentationFirstLine;
    }

    public void setIndentationFirstLine(int indentationFirstLine) {
        this.indentationFirstLine = DxaUtil.dxa2points(indentationFirstLine);
    }

    public int getIndentationLeft() {
        return this.indentationLeft;
    }

    public void setIndentationLeft(int indentationLeft) {
        this.indentationLeft = DxaUtil.dxa2points(indentationLeft);
    }

    public void setIndentationRight(BigInteger indentationRight) {
        this.indentationRight = DxaUtil.dxa2points(indentationRight);
    }

    public int getIndentationRight() {
        return this.indentationRight;
    }

    public void merge(StyleParagraphProperties paragraphProperties) {
        if (paragraphProperties.getAlignment() != -1) {
            this.alignment = paragraphProperties.getAlignment();
        }
        if (paragraphProperties.getLineHeight() != null) {
            this.lineHeight = paragraphProperties.getLineHeight();
        }
    }

    public FontInfos getFontInfos() {
        return this.fontInfos;
    }

    public void setFontInfos(FontInfos fontInfos) {
        this.fontInfos = fontInfos;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public StyleBorder getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(StyleBorder borderTop) {
        this.borderTop = borderTop;
    }

    public StyleBorder getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(StyleBorder borderBottom) {
        this.borderBottom = borderBottom;
    }

    public StyleBorder getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(StyleBorder borderLeft) {
        this.borderLeft = borderLeft;
    }

    public StyleBorder getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(StyleBorder borderRight) {
        this.borderRight = borderRight;
    }

    public void setIndentationRight(int indentationRight) {
        this.indentationRight = indentationRight;
    }
}

