/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedSection;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.IParagraphFactory;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableDocument;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableParagraph;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleParagraphProperties;

public class StylableSection
extends ExtendedSection
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private final StylableDocument ownerDocument;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableSection(StylableDocument ownerDocument, IStylableContainer parent, StylableParagraph title, int numberDepth) {
        super((Paragraph)title, numberDepth);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public void addElement(Element element) {
        super.add((Object)element);
    }

    public void applyStyles(Object ele, Style style) {
        this.lastStyleApplied = style;
        StyleParagraphProperties paragraphProperties = style.getParagraphProperties();
        if (paragraphProperties != null) {
            // empty if block
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this;
    }

    protected IParagraphFactory getParagraphFactory() {
        return this.ownerDocument;
    }

    public IITextContainer getITextContainer() {
        return this.parent;
    }

    public void setITextContainer(IITextContainer container) {
    }
}

