/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.IParagraphFactory;
import java.io.OutputStream;
import org.apache.poi.xwpf.converter.internal.itext.StyleEngineForIText;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableFactory;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableAnchor;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableChapter;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableChunk;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableList;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableListItem;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableParagraph;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylablePhrase;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableSection;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableTable;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableTableCell;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleMargin;
import org.apache.poi.xwpf.converter.internal.itext.styles.StylePageLayoutProperties;

public class StylableDocument
extends ExtendedDocument
implements IStylableContainer,
IStylableFactory,
IParagraphFactory {
    private final StyleEngineForIText styleEngine;
    private Style lastStyleApplied = null;
    private int titleNumber = 1;
    private StylableChapter currentChapter;

    public StylableDocument(OutputStream out, StyleEngineForIText styleEngine) throws DocumentException {
        super(out);
        this.styleEngine = styleEngine;
    }

    public void addElement(Element element) {
        try {
            if (!super.isOpen()) {
                super.open();
            }
            super.add(element);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public StylableParagraph createParagraph(IStylableContainer parent) {
        return new StylableParagraph(this, parent);
    }

    public Paragraph createParagraph() {
        return this.createParagraph((IStylableContainer)null);
    }

    public Paragraph createParagraph(Paragraph title) {
        return new StylableParagraph(this, title, null);
    }

    public StylablePhrase createPhrase(IStylableContainer parent) {
        return new StylablePhrase(this, parent);
    }

    public StylableAnchor createAnchor(IStylableContainer parent) {
        return new StylableAnchor(this, parent);
    }

    public StylableList createList(IStylableContainer parent) {
        return new StylableList(this, parent);
    }

    public StylableListItem createListItem(IStylableContainer parent) {
        return new StylableListItem(this, parent);
    }

    public StylableTable createTable(IStylableContainer parent, int numColumns) {
        return new StylableTable(this, parent, numColumns);
    }

    public StylableTableCell createTableCell(IStylableContainer parent) {
        return new StylableTableCell(this, parent);
    }

    public StylableChapter createChapter(IStylableContainer parent, StylableParagraph title) {
        this.currentChapter = new StylableChapter(this, parent, title, this.titleNumber++);
        return this.currentChapter;
    }

    public StylableChunk createChunk(IStylableContainer parent, String textContent) {
        return new StylableChunk(this, parent, textContent);
    }

    public StylableSection createSection(IStylableContainer parent, StylableParagraph title, int numberDepth) {
        return new StylableSection(this, parent, title, numberDepth);
    }

    public StylableChapter getCurrentChapter() {
        return this.currentChapter;
    }

    public StyleEngineForIText getStyleEngine() {
        return this.styleEngine;
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return null;
    }

    public void applyStyles(Object ele, Style style) {
        this.lastStyleApplied = style;
        StylePageLayoutProperties pageLayoutProperties = style.getPageLayoutProperties();
        if (pageLayoutProperties != null) {
            StyleMargin margin;
            Float width = pageLayoutProperties.getWidth();
            Float height = pageLayoutProperties.getHeight();
            if (width != null && height != null) {
                super.setPageSize(new Rectangle(width.floatValue(), height.floatValue()));
            }
            if ((margin = pageLayoutProperties.getMargin()) != null) {
                if (margin.getMarginTop() != null) {
                    this.originMarginTop = margin.getMarginTop().floatValue();
                }
                if (margin.getMarginBottom() != null) {
                    this.originMarginBottom = margin.getMarginBottom().floatValue();
                }
                if (margin.getMarginRight() != null) {
                    this.originMarginRight = margin.getMarginRight().floatValue();
                }
                if (margin.getMarginLeft() != null) {
                    this.originMarginLeft = margin.getMarginLeft().floatValue();
                }
                super.setMargins(this.originMarginLeft, this.originMarginRight, this.originMarginTop, this.originMarginBottom);
            }
        }
    }

    public Element getElement() {
        return null;
    }
}

