/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext.stylable;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import java.awt.Color;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableElement;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableFactory;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleTextProperties;

public class StylableChunk
extends Chunk
implements IStylableElement {
    private static final long serialVersionUID = 664309269352903329L;
    private final IStylableFactory ownerDocument;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableChunk(IStylableFactory ownerDocument, IStylableContainer parent, String textContent) {
        super(textContent);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public void applyStyles(Object ele, Style style) {
        Color backgroundColor;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (backgroundColor = textProperties.getBackgroundColor()) != null) {
            super.setBackground(backgroundColor);
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this;
    }
}

