/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext;

import com.lowagie.text.Paragraph;
import java.math.BigInteger;
import java.util.List;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextAlignment;
import org.w3c.dom.Attr;

public class XWPFParagraphUtils {
    public static void processLayout(XWPFParagraph paragraph, Paragraph pdfParagraph, XWPFStyle style, CTDocDefaults defaults) {
        float indentationLeft = -1.0f;
        float indentationRight = -1.0f;
        float firstLineIndent = -1.0f;
        float spacingBefore = -1.0f;
        float spacingAfter = -1.0f;
        CTPPr ppr = XWPFParagraphUtils.getPPr(style);
        if (ppr != null) {
            CTTextAlignment textAligment;
            CTSpacing spacing;
            CTInd ind = ppr.getInd();
            if (ind != null) {
                BigInteger firstLine;
                BigInteger right;
                BigInteger left = ind.getLeft();
                if (left != null) {
                    indentationLeft = DxaUtil.dxa2points(left);
                }
                if ((right = ind.getRight()) != null) {
                    indentationRight = DxaUtil.dxa2points(right);
                }
                if ((firstLine = ind.getFirstLine()) != null) {
                    firstLineIndent = DxaUtil.dxa2points(firstLine);
                }
            }
            if ((spacing = ppr.getSpacing()) != null) {
                BigInteger after;
                BigInteger before = spacing.getBefore();
                if (before != null) {
                    spacingBefore = DxaUtil.dxa2points(before);
                }
                if ((after = spacing.getAfter()) != null) {
                    spacingAfter = DxaUtil.dxa2points(after);
                }
            }
            if ((textAligment = ppr.getTextAlignment()) != null) {
                // empty if block
            }
        }
        if (indentationLeft == -1.0f && paragraph.getIndentationLeft() != -1) {
            indentationLeft = DxaUtil.dxa2points(paragraph.getIndentationLeft());
        }
        if (indentationRight == -1.0f && paragraph.getIndentationRight() != -1) {
            indentationRight = DxaUtil.dxa2points(paragraph.getIndentationRight());
        }
        if (firstLineIndent == -1.0f && paragraph.getIndentationFirstLine() != -1) {
            firstLineIndent = DxaUtil.dxa2points(paragraph.getIndentationFirstLine());
        }
        if (spacingBefore == -1.0f && paragraph.getSpacingBefore() != -1) {
            spacingBefore = DxaUtil.dxa2points(paragraph.getSpacingBefore());
        }
        if (spacingAfter == -1.0f && paragraph.getSpacingAfter() != -1) {
            spacingAfter = DxaUtil.dxa2points(paragraph.getSpacingAfter());
        }
        if (indentationLeft != -1.0f) {
            pdfParagraph.setIndentationLeft(indentationLeft);
        }
        if (indentationRight != -1.0f) {
            pdfParagraph.setIndentationRight(indentationRight);
        }
        if (firstLineIndent != -1.0f) {
            pdfParagraph.setFirstLineIndent(firstLineIndent);
        }
        if (spacingBefore != -1.0f) {
            pdfParagraph.setSpacingBefore(spacingBefore);
        }
        if (spacingAfter != -1.0f) {
            pdfParagraph.setSpacingAfter(spacingAfter);
        }
        ParagraphAlignment alignment = paragraph.getAlignment();
        switch (alignment) {
            case LEFT: {
                pdfParagraph.setAlignment(0);
                break;
            }
            case RIGHT: {
                pdfParagraph.setAlignment(2);
                break;
            }
            case CENTER: {
                pdfParagraph.setAlignment(1);
                break;
            }
            case BOTH: {
                pdfParagraph.setAlignment(3);
            }
        }
    }

    public static CTPPr getPPr(XWPFStyle style) {
        if (style == null) {
            return null;
        }
        CTStyle ctStyle = style.getCTStyle();
        if (ctStyle == null) {
            return null;
        }
        return ctStyle.getPPr();
    }

    public static String getBackgroundColor(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        if (runs.isEmpty()) {
            return null;
        }
        return XWPFParagraphUtils.getBackgroundColor((XWPFRun)runs.get(0));
    }

    public static String getBackgroundColor(XWPFRun run) {
        CTR ctr = run.getCTR();
        if (ctr == null) {
            return null;
        }
        CTRPr ctrPr = ctr.getRPr();
        if (ctrPr == null) {
            return null;
        }
        CTShd ctShd = ctrPr.getShd();
        if (ctShd == null) {
            return null;
        }
        Attr attr = (Attr)ctShd.getDomNode().getAttributes().getNamedItemNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fill");
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }
}

