/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext;

import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.utils.BorderType;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.xwpf.converter.internal.AbstractStyleEngine;
import org.apache.poi.xwpf.converter.internal.itext.ColorRegistry;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableParagraph;
import org.apache.poi.xwpf.converter.internal.itext.styles.FontInfos;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleBorder;
import org.apache.poi.xwpf.converter.internal.itext.styles.StyleParagraphProperties;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleEngineForIText
extends AbstractStyleEngine {
    private static final String DEFAULT_STYLE = "default";
    protected static final String BOLD = "bold";
    protected static final String ITALIC = "italic";
    private final Map<String, Style> stylesMap = new HashMap<String, Style>();
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleEngineForIText.class);

    public StyleEngineForIText(XWPFDocument document) {
        super(document);
        this.buildDefault();
    }

    private void buildDefault() {
        try {
            CTDocDefaults defaults = this.document.getStyle().getDocDefaults();
            Style aStyle = new Style(DEFAULT_STYLE);
            if (defaults != null && defaults.getPPrDefault().getPPr() != null) {
                StyleParagraphProperties paragraphProperties = this.mapStyleParagraphProperties(defaults.getPPrDefault().getPPr());
                aStyle.setParagraphProperties(paragraphProperties);
                FontInfos fontInfos = this.processRPR(defaults.getRPrDefault().getRPr());
                paragraphProperties.setFontInfos(fontInfos);
            }
            this.stylesMap.put(DEFAULT_STYLE, aStyle);
        }
        catch (XmlException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void visit(Object ele) {
    }

    public void visit(StylableParagraph ele) {
    }

    private StyleParagraphProperties mapStyleParagraphProperties(CTPPr xwpfParagraphProperties) {
        CTInd ctInd;
        CTTextAlignment alignment;
        StyleParagraphProperties paragraphProperties = new StyleParagraphProperties();
        CTSpacing spacing = xwpfParagraphProperties.getSpacing();
        if (spacing != null) {
            BigInteger spacingAfter;
            BigInteger spacingBefore = spacing.getBefore();
            if (spacingBefore != null) {
                paragraphProperties.setSpacingBefore(spacingBefore.intValue());
            }
            if ((spacingAfter = spacing.getAfter()) != null) {
                paragraphProperties.setSpacingAfter(spacingAfter.intValue());
            }
        }
        if ((alignment = xwpfParagraphProperties.getTextAlignment()) != null) {
            STTextAlignment textAlignment = alignment.xgetVal();
            if (STTextAlignment.BASELINE.equals(textAlignment)) {
                paragraphProperties.setAlignment(7);
            } else if (STTextAlignment.BOTTOM.equals(textAlignment)) {
                paragraphProperties.setAlignment(6);
            } else if (STTextAlignment.CENTER.equals(textAlignment)) {
                paragraphProperties.setAlignment(1);
            } else if (STTextAlignment.TOP.equals(textAlignment)) {
                paragraphProperties.setAlignment(4);
            }
        }
        if ((ctInd = xwpfParagraphProperties.getInd()) != null) {
            this.processIndent(paragraphProperties, ctInd);
        }
        return paragraphProperties;
    }

    private FontInfos processRPR(CTRPr ctParaRPr) {
        STHexColor hexColor;
        String strText;
        CTColor ctColor;
        STUnderline uu;
        boolean italic;
        FontInfos fontInfos = new FontInfos();
        CTFonts fonts = ctParaRPr.getRFonts();
        if (fonts != null && fonts.getAscii() != null) {
            fontInfos.setFontFamilly(fonts.getAscii());
        }
        boolean bold = ctParaRPr.getB() != null && STOnOff.TRUE.equals(ctParaRPr.getB().xgetVal());
        boolean bl = italic = ctParaRPr.getI() != null && STOnOff.TRUE.equals(ctParaRPr.getI().xgetVal());
        if (bold && italic) {
            fontInfos.setFontStyle(3);
        } else if (bold) {
            fontInfos.setFontStyle(1);
        } else if (italic) {
            fontInfos.setFontStyle(2);
        }
        CTHpsMeasure hpsMeasure = ctParaRPr.getSz();
        if (hpsMeasure != null) {
            STHpsMeasure measure = hpsMeasure.xgetVal();
            float size = measure.getBigDecimalValue().floatValue();
            fontInfos.setFontSize(size / 2.0f);
        }
        CTUnderline underline = ctParaRPr.getU();
        int style = fontInfos.getFontStyle();
        if (underline != null && STUnderline.NONE != (uu = underline.xgetVal()).enumValue()) {
            fontInfos.setFontStyle(style |= 4);
        }
        if ((ctColor = ctParaRPr.getColor()) != null && !"auto".equals(strText = (hexColor = ctColor.xgetVal()).getStringValue())) {
            Color color = ColorRegistry.getInstance().getColor("0x" + strText);
            fontInfos.setFontColor(color);
        }
        return fontInfos;
    }

    private void processIndent(StyleParagraphProperties paragraphProperties, CTInd ctInd) {
        BigInteger right;
        BigInteger left;
        BigInteger firstLine = ctInd.getFirstLine();
        if (firstLine != null) {
            paragraphProperties.setIndentationFirstLine(firstLine.intValue());
        }
        if ((left = ctInd.getLeft()) != null) {
            paragraphProperties.setIndentationLeft(left.intValue());
        }
        if ((right = ctInd.getLeft()) != null) {
            paragraphProperties.setIndentationRight(right);
        }
    }

    private StyleBorder createBorder(CTBorder docxBorder, BorderType borderType) {
        if (docxBorder == null) {
            return null;
        }
        StyleBorder styleBorder = new StyleBorder(docxBorder.getVal().toString(), borderType);
        styleBorder.setWidth(docxBorder.getSz().floatValue() / 2.0f);
        STHexColor hexColor = docxBorder.xgetColor();
        Color bc = ColorRegistry.getInstance().getColor(hexColor.getStringValue());
        styleBorder.setColor(bc);
        return styleBorder;
    }

    protected Style buildStyle(String styleID) {
        if (styleID == null) {
            return this.stylesMap.get(DEFAULT_STYLE);
        }
        Style aStyle = this.stylesMap.get(styleID);
        if (aStyle == null) {
            XWPFStyle style = this.document.getStyles().getStyle(styleID);
            aStyle = new Style(styleID);
            CTPPr xwpfParagraphProperties = style.getCTStyle().getPPr();
            if (xwpfParagraphProperties != null) {
                CTPBdr borders;
                StyleParagraphProperties paragraphProperties = this.mapStyleParagraphProperties(xwpfParagraphProperties);
                aStyle.setParagraphProperties(paragraphProperties);
                if (style.getCTStyle().getRPr() != null) {
                    FontInfos fontInfos = this.processRPR(style.getCTStyle().getRPr());
                    paragraphProperties.setFontInfos(fontInfos);
                }
                if ((borders = xwpfParagraphProperties.getPBdr()) != null) {
                    paragraphProperties.setBorderBottom(this.createBorder(borders.getBottom(), BorderType.BOTTOM));
                    paragraphProperties.setBorderLeft(this.createBorder(borders.getLeft(), BorderType.LEFT));
                    paragraphProperties.setBorderRight(this.createBorder(borders.getRight(), BorderType.RIGHT));
                    paragraphProperties.setBorderTop(this.createBorder(borders.getTop(), BorderType.TOP));
                }
            }
            this.stylesMap.put(styleID, aStyle);
        }
        return aStyle;
    }

    protected IITextContainer startVisitDocument(OutputStream out) throws Exception {
        CTStyles styles = this.document.getStyle();
        styles.getDocDefaults().getPPrDefault().getPPr();
        return null;
    }

    protected IITextContainer startVisitPargraph(XWPFParagraph xwpfParagraph, IITextContainer pdfParagraph) throws Exception {
        Style style;
        String styleID = xwpfParagraph.getStyleID();
        if (styleID != null && (style = this.stylesMap.get(styleID)) == null) {
            style = this.buildStyle(styleID);
        }
        return pdfParagraph;
    }

    protected void endVisitPargraph(XWPFParagraph paragraph, IITextContainer parentContainer, IITextContainer paragraphContainer) throws Exception {
    }

    protected void visitEmptyRun(IITextContainer paragraphContainer) throws Exception {
    }

    protected void visitRun(XWPFRun run, IITextContainer paragraphContainer) throws Exception {
    }

    protected IITextContainer startVisitTable(XWPFTable table, IITextContainer tableContainer) throws Exception {
        Style style;
        String styleID;
        CTString str = table.getCTTbl().getTblPr().getTblStyle();
        if (str != null && (styleID = str.getVal()) != null && (style = this.stylesMap.get(styleID)) == null) {
            style = this.buildStyle(styleID);
        }
        return tableContainer;
    }

    protected void endVisitTable(XWPFTable table, IITextContainer parentContainer, IITextContainer tableContainer) throws Exception {
    }

    protected IITextContainer startVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer) {
        return null;
    }

    protected void endVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer, IITextContainer tableCellContainer) {
        System.out.println(cell);
    }

    protected void visitPicture(XWPFPicture picture, IITextContainer parentContainer) throws Exception {
    }

    protected void endVisitDocument() throws Exception {
    }

    protected void visitHeader(CTHdrFtrRef headerRef) throws Exception {
    }

    protected void visitFooter(CTHdrFtrRef footerRef) throws Exception {
    }

    protected void visitParagraph(XWPFParagraph ele) throws Exception {
    }

    public Style getDefaultStyle() {
        return this.stylesMap.get(DEFAULT_STYLE);
    }

    protected Style getStyle(String styleID) {
        if (styleID == null) {
            return this.getDefaultStyle();
        }
        if (!this.document.getStyles().styleExist(styleID)) {
            return this.getDefaultStyle();
        }
        return this.stylesMap.get(styleID);
    }
}

