/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal.itext;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.MasterPage;
import fr.opensagres.xdocreport.itext.extension.MasterPageHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.PageOrientation;
import fr.opensagres.xdocreport.utils.StringUtils;
import java.awt.Color;
import java.io.OutputStream;
import java.util.List;
import java.util.Stack;
import org.apache.poi.xwpf.converter.internal.DxaUtil;
import org.apache.poi.xwpf.converter.internal.XWPFElementVisitor;
import org.apache.poi.xwpf.converter.internal.XWPFRunUtils;
import org.apache.poi.xwpf.converter.internal.XWPFUtils;
import org.apache.poi.xwpf.converter.internal.itext.ColorRegistry;
import org.apache.poi.xwpf.converter.internal.itext.StyleEngineForIText;
import org.apache.poi.xwpf.converter.internal.itext.TableWidth;
import org.apache.poi.xwpf.converter.internal.itext.XWPFFontRegistry;
import org.apache.poi.xwpf.converter.internal.itext.XWPFParagraphUtils;
import org.apache.poi.xwpf.converter.internal.itext.XWPFPictureUtil;
import org.apache.poi.xwpf.converter.internal.itext.XWPFTableUtil;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableContainer;
import org.apache.poi.xwpf.converter.internal.itext.stylable.IStylableElement;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableDocument;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableParagraph;
import org.apache.poi.xwpf.converter.internal.itext.stylable.StylableTable;
import org.apache.poi.xwpf.converter.internal.itext.styles.Style;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMapper
extends XWPFElementVisitor<IITextContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PDFMapper.class);
    private StylableDocument pdfDocument;
    private Stack<CTSectPr> sectPrStack = null;
    private StyleEngineForIText styleEngine;

    public PDFMapper(XWPFDocument document) {
        super(document);
    }

    @Override
    protected IITextContainer startVisitDocument(OutputStream out) throws Exception {
        this.styleEngine = new StyleEngineForIText(this.document);
        this.pdfDocument = new StylableDocument(out, this.styleEngine);
        CTSectPr sectPr = this.document.getDocument().getBody().getSectPr();
        this.applySectPr(sectPr);
        return this.pdfDocument;
    }

    private void applySectPr(CTSectPr sectPr) {
        CTPageMar pageMar;
        if (sectPr == null) {
            return;
        }
        CTPageSz pageSize = sectPr.getPgSz();
        Rectangle pdfPageSize = new Rectangle((float)DxaUtil.dxa2points(pageSize.getW()), (float)DxaUtil.dxa2points(pageSize.getH()));
        this.pdfDocument.setPageSize(pdfPageSize);
        STPageOrientation.Enum orientation = pageSize.getOrient();
        if (orientation != null) {
            if (STPageOrientation.LANDSCAPE.equals(orientation)) {
                this.pdfDocument.setOrientation(PageOrientation.Landscape);
            } else {
                this.pdfDocument.setOrientation(PageOrientation.Portrait);
            }
        }
        if ((pageMar = sectPr.getPgMar()) != null) {
            this.pdfDocument.setOriginalMargins(DxaUtil.dxa2points(pageMar.getLeft()), DxaUtil.dxa2points(pageMar.getRight()), DxaUtil.dxa2points(pageMar.getTop()), DxaUtil.dxa2points(pageMar.getBottom()));
        }
    }

    @Override
    protected void endVisitDocument() throws Exception {
        this.pdfDocument.close();
    }

    @Override
    protected void visitHeader(CTHdrFtrRef headerRef) throws Exception {
        STHdrFtr.Enum type = headerRef.getType();
        MasterPage masterPage = this.getOrCreateMasterPage(type);
        MasterPageHeaderFooter pdfHeader = new MasterPageHeaderFooter();
        XWPFHeader hdr = this.getXWPFHeader(headerRef);
        this.visitBodyElements(hdr.getBodyElements(), (ExtendedPdfPCell)pdfHeader.getTableCell());
        pdfHeader.flush();
        masterPage.setHeader((IMasterPageHeaderFooter)pdfHeader);
    }

    @Override
    protected void visitFooter(CTHdrFtrRef footerRef) throws Exception {
        STHdrFtr.Enum type = footerRef.getType();
        MasterPage masterPage = this.getOrCreateMasterPage(type);
        MasterPageHeaderFooter pdfFooter = new MasterPageHeaderFooter();
        XWPFFooter hdr = this.getXWPFFooter(footerRef);
        this.visitBodyElements(hdr.getBodyElements(), (ExtendedPdfPCell)pdfFooter.getTableCell());
        pdfFooter.flush();
        masterPage.setFooter((IMasterPageHeaderFooter)pdfFooter);
    }

    private MasterPage getOrCreateMasterPage(STHdrFtr.Enum type) {
        String masterPageName = type.toString();
        MasterPage masterPage = this.pdfDocument.getMasterPage(masterPageName);
        if (masterPage == null) {
            masterPage = new MasterPage(masterPageName);
            this.pdfDocument.addMasterPage(masterPage);
        }
        return masterPage;
    }

    private Stack<CTSectPr> getSectPrStack() {
        if (this.sectPrStack != null) {
            return this.sectPrStack;
        }
        this.sectPrStack = new Stack();
        for (IBodyElement bodyElement : this.document.getBodyElements()) {
            CTSectPr sectPr;
            CTPPr ppr;
            if (bodyElement.getElementType() != BodyElementType.PARAGRAPH || (ppr = ((XWPFParagraph)bodyElement).getCTP().getPPr()) == null || (sectPr = ppr.getSectPr()) == null) continue;
            this.sectPrStack.push(sectPr);
        }
        return this.sectPrStack;
    }

    @Override
    protected IITextContainer startVisitPargraph(XWPFParagraph docxParagraph, IITextContainer parentContainer) throws Exception {
        StylableParagraph pdfParagraph = this.pdfDocument.createParagraph((IStylableContainer)null);
        this.styleEngine.startVisitPargraph(docxParagraph, pdfParagraph);
        pdfParagraph.setITextContainer(parentContainer);
        String backgroundColor = XWPFParagraphUtils.getBackgroundColor(docxParagraph);
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            pdfParagraph.getPdfPCell().setBackgroundColor(ColorRegistry.getInstance().getColor("0x" + backgroundColor));
        }
        this.applyStyles(docxParagraph, pdfParagraph);
        return pdfParagraph;
    }

    @Override
    protected void endVisitPargraph(XWPFParagraph paragraph, IITextContainer parentContainer, IITextContainer paragraphContainer) throws Exception {
        CTOnOff pageBreak;
        CTPPr ppr = paragraph.getCTP().getPPr();
        if (ppr.isSetPageBreakBefore() && (pageBreak = ppr.getPageBreakBefore()) != null && (pageBreak.getVal() == null || pageBreak.getVal().intValue() == 1)) {
            this.pdfDocument.newPage();
        }
        ExtendedParagraph pdfParagraph = (ExtendedParagraph)paragraphContainer;
        parentContainer.addElement(pdfParagraph.getContainer());
    }

    @Override
    protected void visitEmptyRun(IITextContainer paragraphContainer) throws Exception {
        ExtendedParagraph pdfParagraph = (ExtendedParagraph)paragraphContainer;
        pdfParagraph.add((Object)Chunk.NEWLINE);
    }

    @Override
    protected void visitRun(XWPFRun run, IITextContainer pdfContainer) throws Exception {
        CTR ctr = run.getCTR();
        CTString rStyle = XWPFRunUtils.getRStyle(run);
        CTRPr runRprStyle = XWPFUtils.getRPr(super.getXWPFStyle(rStyle != null ? rStyle.getVal() : null));
        CTRPr rprStyle = XWPFUtils.getRPr(super.getXWPFStyle(run.getParagraph().getStyleID()));
        CTRPr rprDefault = XWPFUtils.getRPr(this.defaults);
        String fontFamily = XWPFRunUtils.getFontFamily(run, rprStyle, rprDefault);
        float fontSize = run.getFontSize();
        int fontStyle = 0;
        if (XWPFRunUtils.isBold(run, runRprStyle, rprStyle, rprDefault)) {
            fontStyle |= 1;
        }
        if (XWPFRunUtils.isItalic(run, runRprStyle, rprStyle, rprDefault)) {
            fontStyle |= 2;
        }
        Color fontColor = null;
        String hexColor = XWPFRunUtils.getFontColor(run, runRprStyle, rprStyle, rprDefault);
        if (StringUtils.isNotEmpty((String)hexColor) && hexColor != null && !"auto".equals(hexColor)) {
            fontColor = ColorRegistry.getInstance().getColor("0x" + hexColor);
        }
        Font font = XWPFFontRegistry.getRegistry().getFont(fontFamily, fontSize, fontStyle, fontColor);
        UnderlinePatterns underlinePatterns = run.getUnderline();
        boolean singleUnderlined = false;
        switch (underlinePatterns) {
            case SINGLE: {
                singleUnderlined = true;
                break;
            }
        }
        List brs = ctr.getBrList();
        for (CTBr br : brs) {
            pdfContainer.addElement((Element)Chunk.NEWLINE);
        }
        List texts = run.getCTR().getTList();
        for (CTText ctText : texts) {
            Chunk aChunk = new Chunk(ctText.getStringValue(), font);
            if (singleUnderlined) {
                aChunk.setUnderline(1.0f, -2.0f);
            }
            pdfContainer.addElement((Element)aChunk);
        }
        super.visitPictures(run, pdfContainer);
        List lastRenderedPageBreakList = ctr.getLastRenderedPageBreakList();
        if (lastRenderedPageBreakList != null && lastRenderedPageBreakList.size() > 0) {
            Stack<CTSectPr> sectPrStack = this.getSectPrStack();
            if (sectPrStack != null && !sectPrStack.isEmpty()) {
                CTSectPr sectPr = sectPrStack.pop();
                this.applySectPr(sectPr);
            }
            for (CTEmpty lastRenderedPageBreak : lastRenderedPageBreakList) {
                this.pdfDocument.newPage();
            }
        }
    }

    @Override
    protected IITextContainer startVisitTable(XWPFTable table, IITextContainer pdfContainer) throws Exception {
        this.styleEngine.startVisitTable(table, pdfContainer);
        float[] colWidths = XWPFTableUtil.computeColWidths(table);
        TableWidth tableWidth = XWPFTableUtil.getTableWidth(table);
        StylableTable pdfPTable = this.pdfDocument.createTable(null, colWidths.length);
        pdfPTable.setITextContainer(pdfContainer);
        pdfPTable.setTotalWidth(colWidths);
        if (tableWidth.width > 0.0f) {
            if (tableWidth.percentUnit) {
                pdfPTable.setWidthPercentage(tableWidth.width);
            } else {
                pdfPTable.setTotalWidth(tableWidth.width);
            }
        }
        pdfPTable.setLockedWidth(true);
        this.applyStyles(table, pdfPTable);
        return pdfPTable;
    }

    @Override
    protected void endVisitTable(XWPFTable table, IITextContainer parentContainer, IITextContainer tableContainer) throws Exception {
        parentContainer.addElement((Element)tableContainer);
    }

    @Override
    protected IITextContainer startVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer) {
        CTTcBorders borders;
        ExtendedPdfPTable pdfPTable = (ExtendedPdfPTable)tableContainer;
        XWPFTableRow row = cell.getTableRow();
        ExtendedPdfPCell pdfPCell = new ExtendedPdfPCell();
        pdfPCell.setITextContainer((IITextContainer)pdfPTable);
        CTTcPr tcPr = cell.getCTTc().getTcPr();
        Integer colspan = null;
        CTDecimalNumber gridSpan = tcPr.getGridSpan();
        if (gridSpan != null) {
            colspan = gridSpan.getVal().intValue();
        }
        if (colspan != null) {
            pdfPCell.setColspan(colspan.intValue());
        }
        CTShd shd = tcPr.getShd();
        String hexColor = null;
        if (shd != null) {
            hexColor = shd.xgetFill().getStringValue();
        }
        if (hexColor != null && !"auto".equals(hexColor)) {
            pdfPCell.setBackgroundColor(ColorRegistry.getInstance().getColor("0x" + hexColor));
        }
        if ((borders = tcPr.getTcBorders()) != null) {
            XWPFTableUtil.setBorder(borders.getLeft(), (PdfPCell)pdfPCell, 4);
            XWPFTableUtil.setBorder(borders.getRight(), (PdfPCell)pdfPCell, 8);
            XWPFTableUtil.setBorder(borders.getTop(), (PdfPCell)pdfPCell, 1);
            XWPFTableUtil.setBorder(borders.getBottom(), (PdfPCell)pdfPCell, 2);
        }
        int height = row.getHeight();
        pdfPCell.setMinimumHeight((float)DxaUtil.dxa2points(height));
        return pdfPCell;
    }

    @Override
    protected void endVisitTableCell(XWPFTableCell cell, IITextContainer tableContainer, IITextContainer tableCellContainer) {
        ExtendedPdfPTable pdfPTable = (ExtendedPdfPTable)tableContainer;
        ExtendedPdfPCell pdfPCell = (ExtendedPdfPCell)tableCellContainer;
        pdfPTable.addCell((PdfPCell)pdfPCell);
    }

    @Override
    protected void visitPicture(XWPFPicture picture, IITextContainer parentContainer) throws Exception {
        CTPositiveSize2D ext = picture.getCTPicture().getSpPr().getXfrm().getExt();
        long x = ext.getCx();
        long y = ext.getCy();
        CTPicture ctPic = picture.getCTPicture();
        String blipId = ctPic.getBlipFill().getBlip().getEmbed();
        XWPFPictureData pictureData = XWPFPictureUtil.getPictureData(this.document, blipId);
        if (pictureData != null) {
            try {
                Image img = Image.getInstance((byte[])pictureData.getData());
                img.scaleAbsolute(DxaUtil.dxa2points(x) / 635.0f, DxaUtil.dxa2points(y) / 635.0f);
                IITextContainer parentOfParentContainer = parentContainer.getITextContainer();
                if (parentOfParentContainer != null && parentOfParentContainer instanceof PdfPCell) {
                    ((PdfPCell)parentOfParentContainer).setImage(img);
                } else {
                    parentContainer.addElement((Element)img);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
    }

    private void applyStyles(XWPFParagraph ele, IStylableElement<XWPFParagraph> element) {
        Style style = this.styleEngine.getStyle(ele.getStyleID());
        element.applyStyles(ele, style);
    }

    private void applyStyles(XWPFTable ele, IStylableElement<XWPFTable> element) {
        CTString tblStyle = ele.getCTTbl().getTblPr().getTblStyle();
        Style style = tblStyle != null ? this.styleEngine.getStyle(tblStyle.getVal()) : this.styleEngine.getDefaultStyle();
        element.applyStyles(ele, style);
    }

    protected XWPFStyle getXWPFStyle(XWPFParagraph paragraph) {
        if (paragraph == null) {
            return null;
        }
        return this.getXWPFStyle(paragraph.getStyleID());
    }
}

