/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWPFElementVisitor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(XWPFElementVisitor.class);
    protected final XWPFDocument document;
    protected CTDocDefaults defaults;

    public XWPFElementVisitor(XWPFDocument document) {
        this.document = document;
        try {
            this.defaults = document.getStyle().getDocDefaults();
        }
        catch (XmlException e) {
            LOG.error(e.getMessage());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
    }

    public void visit(OutputStream out) throws Exception {
        T container = this.startVisitDocument(out);
        CTSectPr sectPr = this.document.getDocument().getBody().getSectPr();
        this.visitHeadersFooters(sectPr, container);
        List bodyElements = this.document.getBodyElements();
        this.visitBodyElements(bodyElements, container);
        this.endVisitDocument();
        out.close();
    }

    protected abstract T startVisitDocument(OutputStream var1) throws Exception;

    protected abstract void endVisitDocument() throws Exception;

    protected void visitHeadersFooters(CTSectPr sectPr, T container) throws Exception {
        List headersRef = sectPr.getHeaderReferenceList();
        List footersRef = sectPr.getFooterReferenceList();
        for (CTHdrFtrRef headerRef : headersRef) {
            this.visitHeader(headerRef);
        }
        for (CTHdrFtrRef footerRef : footersRef) {
            this.visitFooter(footerRef);
        }
    }

    protected XWPFHeader getXWPFHeader(CTHdrFtrRef headerRef) throws XmlException, IOException {
        PackagePart hdrPart = this.document.getPartById(headerRef.getId());
        HdrDocument hdrDoc = HdrDocument.Factory.parse((InputStream)hdrPart.getInputStream());
        CTHdrFtr hdrFtr = hdrDoc.getHdr();
        XWPFHeader hdr = new XWPFHeader(hdrFtr);
        return hdr;
    }

    protected XWPFFooter getXWPFFooter(CTHdrFtrRef footerRef) throws XmlException, IOException {
        PackagePart hdrPart = this.document.getPartById(footerRef.getId());
        FtrDocument hdrDoc = FtrDocument.Factory.parse((InputStream)hdrPart.getInputStream());
        CTHdrFtr hdrFtr = hdrDoc.getFtr();
        XWPFFooter hdr = new XWPFFooter(hdrFtr);
        return hdr;
    }

    protected abstract void visitHeader(CTHdrFtrRef var1) throws Exception;

    protected abstract void visitFooter(CTHdrFtrRef var1) throws Exception;

    protected void visitBodyElements(List<IBodyElement> bodyElements, T container) throws Exception {
        for (IBodyElement bodyElement : bodyElements) {
            this.visitBodyElement(bodyElement, container);
        }
    }

    protected void visitBodyElement(IBodyElement bodyElement, T container) throws Exception {
        switch (bodyElement.getElementType()) {
            case PARAGRAPH: {
                this.visitParagraph((XWPFParagraph)bodyElement, container);
                break;
            }
            case TABLE: {
                this.visitTable((XWPFTable)bodyElement, container);
            }
        }
    }

    protected void visitParagraph(XWPFParagraph paragraph, T container) throws Exception {
        T paragraphContainer = this.startVisitPargraph(paragraph, container);
        this.visitParagraphBody(paragraph, paragraphContainer);
        this.endVisitPargraph(paragraph, container, paragraphContainer);
    }

    protected abstract T startVisitPargraph(XWPFParagraph var1, T var2) throws Exception;

    protected abstract void endVisitPargraph(XWPFParagraph var1, T var2, T var3) throws Exception;

    protected void visitParagraphBody(XWPFParagraph paragraph, T paragraphContainer) throws Exception {
        List runs = paragraph.getRuns();
        if (runs.isEmpty()) {
            this.visitEmptyRun(paragraphContainer);
        } else {
            for (XWPFRun run : paragraph.getRuns()) {
                this.visitRun(run, paragraphContainer);
            }
        }
    }

    protected abstract void visitEmptyRun(T var1) throws Exception;

    protected abstract void visitRun(XWPFRun var1, T var2) throws Exception;

    protected void visitTable(XWPFTable table, T container) throws Exception {
        T tableContainer = this.startVisitTable(table, container);
        this.visitTableBody(table, tableContainer);
        this.endVisitTable(table, container, tableContainer);
    }

    protected void visitTableBody(XWPFTable table, T tableContainer) throws Exception {
        List rows = table.getRows();
        for (XWPFTableRow row : rows) {
            this.visitTableRow(row, tableContainer);
        }
    }

    protected abstract T startVisitTable(XWPFTable var1, T var2) throws Exception;

    protected abstract void endVisitTable(XWPFTable var1, T var2, T var3) throws Exception;

    protected void visitTableRow(XWPFTableRow row, T tableContainer) throws Exception {
        List cells = row.getTableCells();
        for (XWPFTableCell cell : cells) {
            this.visitCell(cell, tableContainer);
        }
    }

    protected void visitCell(XWPFTableCell cell, T tableContainer) throws Exception {
        T tableCellContainer = this.startVisitTableCell(cell, tableContainer);
        this.visitTableCellBody(cell, tableCellContainer);
        this.endVisitTableCell(cell, tableContainer, tableCellContainer);
    }

    protected void visitTableCellBody(XWPFTableCell cell, T tableCellContainer) throws Exception {
        List bodyElements = cell.getBodyElements();
        this.visitBodyElements(bodyElements, tableCellContainer);
    }

    protected abstract T startVisitTableCell(XWPFTableCell var1, T var2);

    protected abstract void endVisitTableCell(XWPFTableCell var1, T var2, T var3);

    protected void visitPictures(XWPFRun run, T parentContainer) throws Exception {
        List embeddedPictures = run.getEmbeddedPictures();
        for (XWPFPicture picture : embeddedPictures) {
            this.visitPicture(picture, parentContainer);
        }
    }

    protected abstract void visitPicture(XWPFPicture var1, T var2) throws Exception;

    protected XWPFStyle getXWPFStyle(String styleID) {
        if (styleID == null) {
            return null;
        }
        return this.document.getStyles().getStyle(styleID);
    }
}

