/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;

public class ExtendedPdfPTable
extends PdfPTable
implements IITextContainer {
    private IITextContainer container;

    public ExtendedPdfPTable(int numColumns) {
        super(numColumns);
        super.setSpacingBefore(5.0f);
    }

    public void addElement(Element element) {
        super.addCell((PdfPCell)element);
    }

    public IITextContainer getITextContainer() {
        return this.container;
    }

    public void setITextContainer(IITextContainer container) {
        this.container = container;
    }

    public float getRowHeight(int idx, boolean firsttime) {
        if (this.totalWidth <= 0.0f || idx < 0 || idx >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow row = (PdfPRow)this.rows.get(idx);
        if (row == null) {
            return 0.0f;
        }
        if (firsttime) {
            row.setWidths(this.absoluteWidths);
        }
        float height = row.getMaxHeights();
        for (int i = 0; i < this.relativeWidths.length; ++i) {
            if (!this.rowSpanAbove(idx, i)) continue;
            int rs = 1;
            while (this.rowSpanAbove(idx - rs, i)) {
                ++rs;
            }
            PdfPRow tmprow = (PdfPRow)this.rows.get(idx - rs);
            PdfPCell cell = tmprow.getCells()[i];
            float tmp = 0.0f;
            if (cell != null && cell.getRowspan() == rs + 1) {
                tmp = cell.getMaxHeight();
                while (rs > 0) {
                    tmp -= this.getRowHeight(idx - rs);
                    --rs;
                }
            }
            if (!(tmp > height)) continue;
            height = tmp;
        }
        row.setMaxHeights(height);
        return height;
    }

    boolean rowSpanAbove(int currRow, int currCol) {
        if (currCol >= this.getNumberOfColumns() || currCol < 0 || currRow == 0) {
            return false;
        }
        int row = currRow - 1;
        PdfPRow aboveRow = (PdfPRow)this.rows.get(row);
        if (aboveRow == null) {
            return false;
        }
        PdfPCell aboveCell = aboveRow.getCells()[currCol];
        while (aboveCell == null && row > 0) {
            if ((aboveRow = (PdfPRow)this.rows.get(--row)) == null) {
                return false;
            }
            aboveCell = aboveRow.getCells()[currCol];
        }
        int distance = currRow - row;
        if (aboveCell == null) {
            int col = currCol - 1;
            aboveCell = aboveRow.getCells()[col];
            while (aboveCell == null && row > 0) {
                aboveCell = aboveRow.getCells()[--col];
            }
            return aboveCell != null && aboveCell.getRowspan() > distance;
        }
        if (aboveCell.getRowspan() == 1 && distance > 1) {
            int col = currCol - 1;
            aboveRow = (PdfPRow)this.rows.get(row + 1);
            --distance;
            aboveCell = aboveRow.getCells()[col];
            while (aboveCell == null && col > 0) {
                aboveCell = aboveRow.getCells()[--col];
            }
        }
        return aboveCell != null && aboveCell.getRowspan() > distance;
    }
}

