/*
 * Decompiled with CFR 0.152.
 */
package fr.norad.client.bean.validation.js.service;

import fr.norad.client.bean.validation.js.domain.ClientConstraintDescriptor;
import fr.norad.client.bean.validation.js.domain.ClientPropertyDescriptor;
import fr.norad.client.bean.validation.js.domain.ClientValidatorInfo;
import fr.norad.client.bean.validation.js.domain.PropertyType;
import fr.norad.client.bean.validation.js.service.EmptyInterpolatorContext;
import fr.norad.core.lang.reflect.ReflectTools;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;

public class ValidationService {
    private ValidatorFactory validatorFactory;
    private EmptyInterpolatorContext emptyContext = new EmptyInterpolatorContext();

    public ValidationService() {
        this.validatorFactory = Validation.buildDefaultValidatorFactory();
    }

    public ValidationService(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ClientPropertyDescriptor getValidationObject(Class<?> clazz) {
        ClientPropertyDescriptor e = new ClientPropertyDescriptor();
        this.fillValidationObject(clazz, e);
        return e;
    }

    public ClientValidatorInfo getValidatorInfo(Class<?> clazz, Locale locale) {
        ClientValidatorInfo info = new ClientValidatorInfo();
        info.setProperties(this.getValidationObject(clazz));
        info.setMessages(this.getMessages(info.getProperties(), locale));
        return info;
    }

    public ClientValidatorInfo getValidatorInfo(Class<?> clazz) {
        ClientValidatorInfo info = new ClientValidatorInfo();
        info.setProperties(this.getValidationObject(clazz));
        info.setMessages(this.getMessages(info.getProperties(), Locale.getDefault()));
        return info;
    }

    public ClientPropertyDescriptor getValidationObject(Class<?> clazz, String property) {
        ClientPropertyDescriptor clientDescriptor = new ClientPropertyDescriptor();
        BeanDescriptor beanDescriptor = this.validatorFactory.getValidator().getConstraintsForClass(clazz);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(property);
        if (propertyDescriptor != null) {
            this.processConstrainedProperties(clazz, clientDescriptor, propertyDescriptor);
        }
        return clientDescriptor;
    }

    public Map<String, String> getMessages(ClientPropertyDescriptor clientDescriptor, Locale locale) {
        HashMap<String, String> res = new HashMap<String, String>();
        this.findMessagesRec(res, clientDescriptor, locale);
        return res;
    }

    public Map<String, String> getMessages(ClientPropertyDescriptor clientDescriptor) {
        HashMap<String, String> res = new HashMap<String, String>();
        this.findMessagesRec(res, clientDescriptor, Locale.getDefault());
        return res;
    }

    private void findMessagesRec(HashMap<String, String> res, ClientPropertyDescriptor clientDescriptor, Locale locale) {
        if (clientDescriptor == null) {
            return;
        }
        if (clientDescriptor.getConstraints() != null) {
            for (ClientConstraintDescriptor constraint : clientDescriptor.getConstraints()) {
                if (res.containsKey(constraint.getType())) continue;
                String message = constraint.getAttributes().get("message").toString();
                String interpolation = this.validatorFactory.getMessageInterpolator().interpolate(message, (MessageInterpolator.Context)this.emptyContext, locale);
                res.put(message, interpolation);
            }
        }
        if (clientDescriptor.getProperties() != null) {
            for (ClientPropertyDescriptor property : clientDescriptor.getProperties().values()) {
                this.findMessagesRec(res, property, locale);
            }
        }
    }

    private void fillValidationObject(Class<?> clazz, ClientPropertyDescriptor clientDescriptor) {
        BeanDescriptor beanDescriptor = this.validatorFactory.getValidator().getConstraintsForClass(clazz);
        Set beanConstraints = beanDescriptor.getConstraintDescriptors();
        for (ConstraintDescriptor constraintDescriptor : beanConstraints) {
            ClientConstraintDescriptor clientConstraintDescriptor = new ClientConstraintDescriptor();
            this.fillClientConstraintFromServerConstraint(clientConstraintDescriptor, constraintDescriptor);
            clientDescriptor.retreaveCreatedConstraints().add(clientConstraintDescriptor);
        }
        Set constrainedProperties = beanDescriptor.getConstrainedProperties();
        for (PropertyDescriptor propertyDescriptor : constrainedProperties) {
            this.processConstrainedProperties(clazz, clientDescriptor, propertyDescriptor);
        }
    }

    private void processConstrainedProperties(Class<?> clazz, ClientPropertyDescriptor clientDescriptor, PropertyDescriptor propertyDescriptor) {
        ClientPropertyDescriptor element = new ClientPropertyDescriptor();
        String propertyName = propertyDescriptor.getPropertyName();
        clientDescriptor.retreaveCreatedProperties().put(propertyName, element);
        Set constraintDescriptors = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[0]).getConstraintDescriptors();
        for (ConstraintDescriptor constraintDescriptor : propertyDescriptor.getConstraintDescriptors()) {
            ClientConstraintDescriptor constraint = new ClientConstraintDescriptor();
            this.fillClientConstraintFromServerConstraint(constraint, constraintDescriptor);
            element.retreaveCreatedConstraints().add(constraint);
        }
        if (propertyDescriptor.isCascaded()) {
            Class elementClass = propertyDescriptor.getElementClass();
            if (ReflectTools.classImplement((Class)elementClass, List.class)) {
                try {
                    Field field = clazz.getDeclaredField(propertyName);
                    ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
                    Class elementListClass = (Class)stringListType.getActualTypeArguments()[0];
                    element.setPropertyType(PropertyType.ARRAY);
                    this.fillValidationObject(elementListClass, element);
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
            } else if (!ReflectTools.classImplement((Class)elementClass, Map.class) && elementClass != String.class) {
                this.fillValidationObject(elementClass, element);
            }
        }
    }

    private void fillClientConstraintFromServerConstraint(ClientConstraintDescriptor clientConstraint, ConstraintDescriptor<?> serverConstraint) {
        clientConstraint.setType(serverConstraint.getAnnotation().annotationType().getName());
        clientConstraint.setReportAsSingle(serverConstraint.isReportAsSingleViolation());
        HashMap<String, Object> attributes = new HashMap<String, Object>(serverConstraint.getAttributes());
        if (((Class[])attributes.get("groups")).length == 0) {
            attributes.remove("groups");
        }
        if (((Class[])attributes.get("payload")).length == 0) {
            attributes.remove("payload");
        }
        clientConstraint.setAttributes(attributes);
        Set composingConstraints = serverConstraint.getComposingConstraints();
        if (!composingConstraints.isEmpty()) {
            HashSet<ClientConstraintDescriptor> constraints = new HashSet<ClientConstraintDescriptor>(composingConstraints.size());
            clientConstraint.setComposingConstraints(constraints);
            for (ConstraintDescriptor serverComposingConstraint : composingConstraints) {
                ClientConstraintDescriptor clientComposingConstraint = new ClientConstraintDescriptor();
                constraints.add(clientComposingConstraint);
                this.fillClientConstraintFromServerConstraint(clientComposingConstraint, serverComposingConstraint);
            }
        }
    }
}

