/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.detect.Analyze;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Visitor;

public class SerializableIdiom
extends BytecodeScanningDetector {
    boolean sawSerialVersionUID;
    boolean isSerializable;
    boolean implementsSerializableDirectly;
    boolean isExternalizable;
    boolean isGUIClass;
    boolean foundSynthetic;
    boolean seenTransientField;
    boolean foundSynchronizedMethods;
    boolean writeObjectIsSynchronized;
    private BugReporter bugReporter;
    boolean isAbstract;
    private List<BugInstance> fieldWarningList = new LinkedList<BugInstance>();
    private HashMap<String, XField> fieldsThatMightBeAProblem = new HashMap();
    private boolean sawReadExternal;
    private boolean sawWriteExternal;
    private boolean sawReadObject;
    private boolean sawWriteObject;
    private boolean superClassImplementsSerializable;
    private boolean hasPublicVoidConstructor;
    private boolean superClassHasVoidConstructor;
    private boolean directlyImplementsExternalizable;
    static Pattern anonymousInnerClassNamePattern = Pattern.compile(".+\\$\\d+");
    boolean isAnonymousInnerClass;
    private boolean isEnum;
    private OpcodeStack stack = new OpcodeStack();

    public SerializableIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
        this.flush();
    }

    private void flush() {
        if (!(this.isAbstract || this.sawReadExternal && this.sawWriteExternal || this.sawReadObject && this.sawWriteObject)) {
            Iterator<BugInstance> i$ = this.fieldWarningList.iterator();
            while (i$.hasNext()) {
                BugInstance aFieldWarningList = i$.next();
                this.bugReporter.reportBug(aFieldWarningList);
            }
        }
        this.fieldWarningList.clear();
    }

    public void visit(JavaClass obj) {
        block13: {
            String[] interface_names;
            String superClassname = obj.getSuperclassName();
            this.isEnum = superClassname.equals("java.lang.Enum");
            if (this.isEnum) {
                return;
            }
            int flags = obj.getAccessFlags();
            this.isAbstract = (flags & 0x400) != 0 || (flags & 0x200) != 0;
            this.isAnonymousInnerClass = anonymousInnerClassNamePattern.matcher(this.getClassName()).matches();
            this.sawSerialVersionUID = false;
            this.implementsSerializableDirectly = false;
            this.isSerializable = false;
            this.isExternalizable = false;
            this.directlyImplementsExternalizable = false;
            this.isGUIClass = false;
            this.seenTransientField = false;
            boolean isEnum = obj.getSuperclassName().equals("java.lang.Enum");
            this.fieldsThatMightBeAProblem.clear();
            String[] arr$ = interface_names = obj.getInterfaceNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String interface_name = arr$[i$];
                if (interface_name.equals("java.io.Externalizable")) {
                    this.directlyImplementsExternalizable = true;
                    this.isExternalizable = true;
                    continue;
                }
                if (!interface_name.equals("java.io.Serializable")) continue;
                this.implementsSerializableDirectly = true;
                this.isSerializable = true;
                break;
            }
            if (!this.isSerializable) {
                try {
                    if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Externalizable")) {
                        this.isExternalizable = true;
                    }
                    if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                        this.isSerializable = true;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
            }
            this.hasPublicVoidConstructor = false;
            this.superClassHasVoidConstructor = true;
            this.superClassImplementsSerializable = this.isSerializable && !this.implementsSerializableDirectly;
            try {
                JavaClass superClass = obj.getSuperClass();
                if (superClass == null) break block13;
                Method[] superClassMethods = superClass.getMethods();
                this.superClassImplementsSerializable = Repository.instanceOf((JavaClass)superClass, (String)"java.io.Serializable");
                this.superClassHasVoidConstructor = false;
                Method[] arr$2 = superClassMethods;
                int len$2 = arr$2.length;
                for (int i$ = 0; i$ < len$2; ++i$) {
                    Method m = arr$2[i$];
                    if (!m.getName().equals("<init>") || !m.getSignature().equals("()V") || m.isPrivate()) continue;
                    this.superClassHasVoidConstructor = true;
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        try {
            this.isGUIClass = Repository.instanceOf((JavaClass)obj, (String)"java.lang.Throwable") || Repository.instanceOf((JavaClass)obj, (String)"java.awt.Component") || Repository.implementationOf((JavaClass)obj, (String)"java.awt.event.ActionListener") || Repository.implementationOf((JavaClass)obj, (String)"java.util.EventListener");
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        this.foundSynthetic = false;
        this.foundSynchronizedMethods = false;
        this.writeObjectIsSynchronized = false;
        this.sawWriteObject = false;
        this.sawReadObject = false;
        this.sawWriteExternal = false;
        this.sawReadExternal = false;
    }

    public void visitAfter(JavaClass obj) {
        if (this.isEnum) {
            return;
        }
        if (this.isSerializable && !this.isExternalizable && !this.superClassHasVoidConstructor && !this.superClassImplementsSerializable) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NO_SUITABLE_CONSTRUCTOR", this.implementsSerializableDirectly ? 1 : (this.sawSerialVersionUID ? 2 : 3)).addClass(this.getThisClass().getClassName()));
        }
        int priority = 2;
        if (obj.getClassName().endsWith("_Stub")) {
            ++priority;
        }
        if (this.isExternalizable && !this.hasPublicVoidConstructor && !this.isAbstract) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION", this.directlyImplementsExternalizable ? 1 : 2).addClass(this.getThisClass().getClassName()));
        }
        if (!this.foundSynthetic) {
            ++priority;
        }
        if (!(this.isAnonymousInnerClass || this.isExternalizable || this.isGUIClass || !this.isSerializable || this.isAbstract || this.sawSerialVersionUID)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NO_SERIALVERSIONID", priority).addClass((PreorderVisitor)this));
        }
        if (this.writeObjectIsSynchronized && !this.foundSynchronizedMethods) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "WS_WRITEOBJECT_SYNC", 3).addClass((PreorderVisitor)this));
        }
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int accessFlags = obj.getAccessFlags();
        boolean bl = isSynchronized = (accessFlags & 0x20) != 0;
        if (this.getMethodName().equals("<init>") && this.getMethodSig().equals("()V") && (accessFlags & 1) != 0) {
            this.hasPublicVoidConstructor = true;
        }
        if (!this.getMethodName().equals("<init>") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (this.getMethodName().equals("readExternal") && this.getMethodSig().equals("(Ljava/io/ObjectInput;)V")) {
            this.sawReadExternal = true;
        } else if (this.getMethodName().equals("writeExternal") && this.getMethodSig().equals("(Ljava/io/Objectoutput;)V")) {
            this.sawWriteExternal = true;
        } else if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_METHOD_MUST_BE_PRIVATE", 1).addClassAndMethod((PreorderVisitor)this));
            }
        } else if (this.getMethodName().equals("readObjectNoData") && this.getMethodSig().equals("()V") && this.isSerializable) {
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_METHOD_MUST_BE_PRIVATE", 1).addClassAndMethod((PreorderVisitor)this));
            }
        } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_METHOD_MUST_BE_PRIVATE", 1).addClassAndMethod((PreorderVisitor)this));
            }
        }
        if (isSynchronized) {
            if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "RS_READOBJECT_SYNC", 2).addClass((PreorderVisitor)this));
            } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
                this.writeObjectIsSynchronized = true;
            } else {
                this.foundSynchronizedMethods = true;
            }
        }
        super.visit(obj);
    }

    boolean isSynthetic(FieldOrMethod obj) {
        Attribute[] a;
        Attribute[] arr$ = a = obj.getAttributes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Attribute aA = arr$[i$];
            if (!(aA instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public void visit(Code obj) {
        if (this.isSerializable) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 181) {
            String nameOfClass = this.getClassConstantOperand();
            String nameOfField = this.getNameConstantOperand();
            if (this.getClassName().equals(nameOfClass) && this.fieldsThatMightBeAProblem.containsKey(nameOfField)) {
                try {
                    String genSig;
                    XField f;
                    String sig;
                    OpcodeStack.Item first = this.stack.getStackItem(0);
                    JavaClass classStored = first.getJavaClass();
                    double isSerializable = Analyze.isDeepSerializable(classStored);
                    if (isSerializable <= 0.2 && !(sig = (f = this.fieldsThatMightBeAProblem.get(nameOfField)).getSignature()).equals(genSig = "L" + classStored.getClassName().replace('.', '/') + ";")) {
                        double bias = 0.0;
                        if (!this.getMethodName().equals("<init>")) {
                            bias = 1.0;
                        }
                        int priority = this.computePriority(isSerializable, bias);
                        this.fieldWarningList.add(new BugInstance((Detector)this, "SE_BAD_FIELD_STORE", priority).addClass(this.getThisClass().getClassName()).addField(f).addClass(classStored).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    public void visit(Field obj) {
        int flags = obj.getAccessFlags();
        if (obj.isTransient()) {
            this.seenTransientField = true;
        }
        if (this.getClassName().indexOf("ObjectStreamClass") == -1 && this.isSerializable && !this.isExternalizable && this.getFieldSig().indexOf("L") >= 0 && !obj.isTransient() && !obj.isStatic()) {
            try {
                double isSerializable = Analyze.isDeepSerializable(this.getFieldSig());
                if (isSerializable < 1.0) {
                    this.fieldsThatMightBeAProblem.put(obj.getName(), XFactory.createXField((PreorderVisitor)this));
                }
                if (isSerializable < 0.9) {
                    int priority = this.computePriority(isSerializable, 0.0);
                    if (priority > 2 && obj.getName().startsWith("this$")) {
                        priority = 2;
                    }
                    this.fieldWarningList.add(new BugInstance((Detector)this, "SE_BAD_FIELD", priority).addClass(this.getThisClass().getClassName()).addField(this.getDottedClassName(), obj.getName(), this.getFieldSig(), false));
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        if (!this.getFieldName().startsWith("this") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (!this.getFieldName().equals("serialVersionUID")) {
            return;
        }
        int mask = 24;
        if (!this.getFieldSig().equals("I") && !this.getFieldSig().equals("J")) {
            return;
        }
        if ((flags & mask) == mask && this.getFieldSig().equals("I")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NONLONG_SERIALVERSIONID", 3).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            this.sawSerialVersionUID = true;
            return;
        }
        if ((flags & 8) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NONSTATIC_SERIALVERSIONID", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            return;
        }
        if ((flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NONFINAL_SERIALVERSIONID", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            return;
        }
        this.sawSerialVersionUID = true;
    }

    private int computePriority(double isSerializable, double bias) {
        int priority = (int)(1.9 + isSerializable * 3.0 + bias);
        if (this.implementsSerializableDirectly || this.sawSerialVersionUID) {
            --priority;
        }
        if (!this.implementsSerializableDirectly && priority == 1) {
            priority = 2;
        }
        return priority;
    }
}

