/*
 * Decompiled with CFR 0.152.
 */
package com.couponornot.social.txwb.connect.oauth1;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.http.HttpMethod;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriUtils;

public class TxwbOauth1Support {
    private TimestampGenerator timestampGenerator = new DefaultTimestampGenerator();
    private static final String HMAC_SHA1_SIGNATURE_NAME = "HMAC-SHA1";
    private static final String HMAC_SHA1_MAC_NAME = "HmacSHA1";
    private static final String UTF8_CHARSET_NAME = "UTF-8";
    private static final BitSet UNRESERVED;

    static {
        BitSet alpha = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            alpha.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            alpha.set(i);
            ++i;
        }
        BitSet digit = new BitSet(256);
        int i2 = 48;
        while (i2 <= 57) {
            digit.set(i2);
            ++i2;
        }
        BitSet unreserved = new BitSet(256);
        unreserved.or(alpha);
        unreserved.or(digit);
        unreserved.set(45);
        unreserved.set(46);
        unreserved.set(95);
        unreserved.set(126);
        UNRESERVED = unreserved;
    }

    public MultiValueMap<String, String> commonOAuthParameters(String consumerKey, HttpMethod method, String targetUrl, MultiValueMap<String, String> additionalParameters, String consumerSecret, String tokenSecret) {
        HashMap<String, String> oauthParameters = new HashMap<String, String>();
        oauthParameters.put("oauth_consumer_key", consumerKey);
        oauthParameters.put("oauth_signature_method", HMAC_SHA1_SIGNATURE_NAME);
        long timestamp = this.timestampGenerator.generateTimestamp();
        oauthParameters.put("oauth_timestamp", Long.toString(timestamp));
        oauthParameters.put("oauth_nonce", Long.toString(this.timestampGenerator.generateNonce(timestamp)));
        oauthParameters.put("oauth_version", "1.0");
        LinkedMultiValueMap collectedParameters = new LinkedMultiValueMap((int)((double)(oauthParameters.size() + additionalParameters.size()) / 0.75 + 1.0));
        collectedParameters.setAll(oauthParameters);
        collectedParameters.putAll(additionalParameters);
        String baseString = this.buildBaseString(method, this.getBaseStringUri(this.encodeTokenUri(targetUrl)), (MultiValueMap<String, String>)collectedParameters);
        String signature = this.calculateSignature(baseString, consumerSecret, tokenSecret);
        collectedParameters.add((Object)"oauth_signature", (Object)signature);
        return collectedParameters;
    }

    private URI encodeTokenUri(String url) {
        try {
            return new URI(UriUtils.encodeUri((String)url, (String)UTF8_CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Not a valid url: " + url, e);
        }
    }

    private String calculateSignature(String baseString, String consumerSecret, String tokenSecret) {
        String key = String.valueOf(TxwbOauth1Support.oauthEncode(consumerSecret)) + "&" + (tokenSecret != null ? TxwbOauth1Support.oauthEncode(tokenSecret) : "");
        return this.sign(baseString, key);
    }

    private String getBaseStringUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), this.getPort(uri), uri.getPath(), null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private int getPort(URI uri) {
        if (uri.getScheme().equals("http") && uri.getPort() == 80 || uri.getScheme().equals("https") && uri.getPort() == 443) {
            return -1;
        }
        return uri.getPort();
    }

    private String sign(String signatureBaseString, String key) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1_MAC_NAME);
            SecretKeySpec spec = new SecretKeySpec(key.getBytes(), HMAC_SHA1_MAC_NAME);
            mac.init(spec);
            byte[] text = signatureBaseString.getBytes(UTF8_CHARSET_NAME);
            byte[] signatureBytes = mac.doFinal(text);
            signatureBytes = Base64.encode((byte[])signatureBytes);
            String signature = new String(signatureBytes, UTF8_CHARSET_NAME);
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException shouldntHappen) {
            throw new IllegalStateException(shouldntHappen);
        }
    }

    private String buildBaseString(HttpMethod method, String targetUrl, MultiValueMap<String, String> collectedParameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.name()).append('&').append(TxwbOauth1Support.oauthEncode(targetUrl)).append('&');
        builder.append(TxwbOauth1Support.oauthEncode(this.normalizeParameters(collectedParameters)));
        return builder.toString();
    }

    private String normalizeParameters(MultiValueMap<String, String> collectedParameters) {
        TreeMultiValueMap sortedEncodedParameters = new TreeMultiValueMap();
        for (Map.Entry entry : collectedParameters.entrySet()) {
            String collectedName = (String)entry.getKey();
            List collectedValues = (List)entry.getValue();
            ArrayList<String> encodedValues = new ArrayList<String>(collectedValues.size());
            sortedEncodedParameters.put(TxwbOauth1Support.oauthEncode(collectedName), encodedValues);
            for (String value : collectedValues) {
                encodedValues.add(value != null ? TxwbOauth1Support.oauthEncode(value) : "");
            }
            Collections.sort(encodedValues);
        }
        StringBuilder paramsBuilder = new StringBuilder();
        Iterator entryIt = sortedEncodedParameters.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIt.next();
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            Iterator valueIt = values.iterator();
            while (valueIt.hasNext()) {
                String value;
                value = (String)valueIt.next();
                paramsBuilder.append(name).append('=').append(value);
                if (!valueIt.hasNext()) continue;
                paramsBuilder.append("&");
            }
            if (!entryIt.hasNext()) continue;
            paramsBuilder.append("&");
        }
        return paramsBuilder.toString();
    }

    private static String oauthEncode(String param) {
        try {
            byte[] bytes = TxwbOauth1Support.encode(param.getBytes(UTF8_CHARSET_NAME), UNRESERVED);
            return new String(bytes, "US-ASCII");
        }
        catch (Exception shouldntHappen) {
            throw new IllegalStateException(shouldntHappen);
        }
    }

    private static byte[] encode(byte[] source, BitSet notEncoded) {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length * 2);
        int i = 0;
        while (i < source.length) {
            int b = source[i];
            if (b < 0) {
                b += 256;
            }
            if (notEncoded.get(b)) {
                bos.write(b);
            } else {
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            ++i;
        }
        return bos.toByteArray();
    }

    private static class DefaultTimestampGenerator
    implements TimestampGenerator {
        static final Random RANDOM = new Random();

        private DefaultTimestampGenerator() {
        }

        @Override
        public long generateTimestamp() {
            return System.currentTimeMillis() / 1000L;
        }

        @Override
        public long generateNonce(long timestamp) {
            return timestamp + (long)RANDOM.nextInt();
        }
    }

    static interface TimestampGenerator {
        public long generateTimestamp();

        public long generateNonce(long var1);
    }

    private static class TreeMultiValueMap<K, V>
    implements MultiValueMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 3801124242820219131L;
        private final Map<K, List<V>> targetMap;

        public TreeMultiValueMap() {
            this.targetMap = new TreeMap<K, List<V>>();
        }

        public TreeMultiValueMap(Map<K, List<V>> otherMap) {
            this.targetMap = new TreeMap<K, List<List<V>>>(otherMap);
        }

        public void add(K key, V value) {
            List<V> values = this.targetMap.get(key);
            if (values == null) {
                values = new LinkedList<V>();
                this.targetMap.put(key, values);
            }
            values.add(value);
        }

        public V getFirst(K key) {
            List<V> values = this.targetMap.get(key);
            return values != null ? (V)values.get(0) : null;
        }

        public void set(K key, V value) {
            LinkedList<V> values = new LinkedList<V>();
            values.add(value);
            this.targetMap.put(key, values);
        }

        public void setAll(Map<K, V> values) {
            for (Map.Entry<K, V> entry : values.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }

        public Map<K, V> toSingleValueMap() {
            LinkedHashMap<K, V> singleValueMap = new LinkedHashMap<K, V>(this.targetMap.size());
            for (Map.Entry<K, List<V>> entry : this.targetMap.entrySet()) {
                singleValueMap.put(entry.getKey(), entry.getValue().get(0));
            }
            return singleValueMap;
        }

        public int size() {
            return this.targetMap.size();
        }

        public boolean isEmpty() {
            return this.targetMap.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.targetMap.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.targetMap.containsValue(value);
        }

        public List<V> get(Object key) {
            return this.targetMap.get(key);
        }

        public List<V> put(K key, List<V> value) {
            return this.targetMap.put(key, value);
        }

        public List<V> remove(Object key) {
            return this.targetMap.remove(key);
        }

        public void putAll(Map<? extends K, ? extends List<V>> m) {
            this.targetMap.putAll(m);
        }

        public void clear() {
            this.targetMap.clear();
        }

        public Set<K> keySet() {
            return this.targetMap.keySet();
        }

        public Collection<List<V>> values() {
            return this.targetMap.values();
        }

        public Set<Map.Entry<K, List<V>>> entrySet() {
            return this.targetMap.entrySet();
        }

        public boolean equals(Object obj) {
            return this.targetMap.equals(obj);
        }

        public int hashCode() {
            return this.targetMap.hashCode();
        }

        public String toString() {
            return this.targetMap.toString();
        }
    }
}

