/*
 * Decompiled with CFR 0.152.
 */
package com.couponornot.social.txwb.api.oauth1;

import com.couponornot.social.txwb.api.Txwb;
import com.couponornot.social.txwb.api.UserOperations;
import com.couponornot.social.txwb.api.json.TxwbObjectMapper;
import com.couponornot.social.txwb.api.oauth1.UserTemplate;
import com.couponornot.social.txwb.connect.oauth1.TxwbOauth1Support;
import java.util.ArrayList;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;
import org.springframework.util.MultiValueMap;

public class TxwbTemplate
extends AbstractOAuth1ApiBinding
implements Txwb {
    private UserOperations userOperations;
    private ObjectMapper objectMapper;
    private TxwbOauth1Support oauth1Support;
    private final String consumerKey;
    private final String consumerSecret;
    private final String accessTokenSecret;
    private final String accessToken;

    public TxwbTemplate() {
        this.initialize();
        this.consumerKey = null;
        this.consumerSecret = null;
        this.accessTokenSecret = null;
        this.accessToken = null;
    }

    public TxwbTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        super(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.initialize();
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.accessTokenSecret = accessTokenSecret;
        this.accessToken = accessToken;
    }

    private void initialize() {
        this.oauth1Support = new TxwbOauth1Support();
        this.userOperations = new UserTemplate(this, this.getRestTemplate(), this.isAuthorized());
    }

    @Override
    public MultiValueMap<String, String> commonOAuthParameters(HttpMethod method, String targetUrl, MultiValueMap<String, String> additionalParameters) {
        additionalParameters.add((Object)"oauth_token", (Object)this.accessToken);
        return this.oauth1Support.commonOAuthParameters(this.consumerKey, method, targetUrl, additionalParameters, this.consumerSecret, this.accessTokenSecret);
    }

    @Override
    public UserOperations userOperations() {
        return this.userOperations;
    }

    protected MappingJacksonHttpMessageConverter getJsonMessageConverter() {
        MappingJacksonHttpMessageConverter converter = super.getJsonMessageConverter();
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.addAll(converter.getSupportedMediaTypes());
        list.add(MediaType.TEXT_HTML);
        converter.setSupportedMediaTypes(list);
        this.objectMapper = new TxwbObjectMapper();
        converter.setObjectMapper(this.objectMapper);
        return converter;
    }
}

