/*
 * Decompiled with CFR 0.152.
 */
package com.couponornot.social.txwb.api.oauth1;

import com.couponornot.social.txwb.api.Txwb;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AbstractTxwbOperations
extends AbstractOAuth1ApiBinding {
    protected static final String API_URL = "http://open.t.qq.com/api/";
    private final boolean isAuthorized;
    protected final RestTemplate restTemplate;
    protected final Txwb api;

    public AbstractTxwbOperations(Txwb api, RestTemplate restTemplate, boolean isAuthorized) {
        this.api = api;
        this.restTemplate = restTemplate;
        this.isAuthorized = isAuthorized;
    }

    protected void requireAuthorization() {
        if (!this.isAuthorized) {
            throw new MissingAuthorizationException();
        }
    }

    protected URI buildUrl(String url) {
        return this.buildUrl(url, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    protected URI buildUrl(String url, MultiValueMap<String, String> parameters, HttpMethod method) {
        return URIBuilder.fromUri((String)(API_URL + url)).queryParams(this.api.commonOAuthParameters(method, API_URL + url, parameters)).build();
    }

    protected URI buildUrl(String url, MultiValueMap<String, String> parameters) {
        return this.buildUrl(url, parameters, HttpMethod.GET);
    }

    protected URI buildUrl(String url, String name, String value) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)name, (Object)value);
        return this.buildUrl(url, (MultiValueMap<String, String>)parameters);
    }
}

