/*
 * Decompiled with CFR 0.152.
 */
package com.couponornot.social.txwb.connect.oauth1;

import com.couponornot.social.txwb.connect.oauth1.TxwbOauth1Support;
import java.net.URI;
import java.util.ArrayList;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Template;
import org.springframework.social.oauth1.OAuth1Version;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TxwbOauth1Template
extends OAuth1Template {
    private final TxwbOauth1Support oauth1Support;
    private final RestTemplate restTemplate = this.createRestTemplate();
    private final String requestTokenUrl;
    private final String accessTokenUrl;
    private final String consumerKey;
    private final String consumerSecret;

    public TxwbOauth1Template(String consumerKey, String consumerSecret, String requestTokenUrl, String authorizeUrl, String accessTokenUrl) {
        super(consumerKey, consumerSecret, requestTokenUrl, authorizeUrl, accessTokenUrl);
        this.requestTokenUrl = requestTokenUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.oauth1Support = new TxwbOauth1Support();
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    private RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        ArrayList<1> converters = new ArrayList<1>(1);
        converters.add(new FormHttpMessageConverter(){

            public boolean canRead(Class<?> clazz, MediaType mediaType) {
                return MultiValueMap.class.isAssignableFrom(clazz);
            }
        });
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }

    public OAuthToken fetchRequestToken(String callbackUrl, MultiValueMap<String, String> additionalParameters) {
        additionalParameters = new LinkedMultiValueMap(1);
        if (this.getVersion() == OAuth1Version.CORE_10_REVISION_A) {
            additionalParameters.add((Object)"oauth_callback", (Object)callbackUrl);
        }
        return this.exchangeForToken(this.requestTokenUrl, (MultiValueMap<String, String>)additionalParameters, "");
    }

    private OAuthToken exchangeForToken(String otokenUrl, MultiValueMap<String, String> additionalParameters, String tokenSecret) {
        URI tokenUrl = URIBuilder.fromUri((String)otokenUrl).queryParams(this.oauth1Support.commonOAuthParameters(this.consumerKey, HttpMethod.GET, otokenUrl, additionalParameters, this.consumerSecret, tokenSecret)).build();
        ResponseEntity response = this.restTemplate.exchange(tokenUrl, HttpMethod.GET, null, MultiValueMap.class);
        MultiValueMap body = (MultiValueMap)response.getBody();
        return this.createOAuthToken((String)body.getFirst((Object)"oauth_token"), (String)body.getFirst((Object)"oauth_token_secret"), body);
    }

    public OAuthToken exchangeForAccessToken(AuthorizedRequestToken requestToken, MultiValueMap<String, String> additionalParameters) {
        additionalParameters = new LinkedMultiValueMap(1);
        additionalParameters.add((Object)"oauth_token", (Object)requestToken.getValue());
        if (this.getVersion() == OAuth1Version.CORE_10_REVISION_A) {
            additionalParameters.add((Object)"oauth_verifier", (Object)requestToken.getVerifier());
        }
        return this.exchangeForToken(this.accessTokenUrl, (MultiValueMap<String, String>)additionalParameters, requestToken.getSecret());
    }
}

