/*
 * Decompiled with CFR 0.152.
 */
package com.couponornot.social.txwb.api.oauth1;

import com.couponornot.social.txwb.api.Txwb;
import com.couponornot.social.txwb.api.TxwbProfile;
import com.couponornot.social.txwb.api.TxwbProfileList;
import com.couponornot.social.txwb.api.UserOperations;
import com.couponornot.social.txwb.api.oauth1.AbstractTxwbOperations;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class UserTemplate
extends AbstractTxwbOperations
implements UserOperations {
    public UserTemplate(Txwb api, RestTemplate restTemplate, boolean isAuthorized) {
        super(api, restTemplate, isAuthorized);
    }

    @Override
    public TxwbProfile getUserProfile() {
        this.isAuthorized();
        return (TxwbProfile)this.restTemplate.getForObject(this.buildUrl("user/info"), TxwbProfile.class);
    }

    @Override
    public TxwbProfile getUserProfile(String screenName) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)screenName);
        return (TxwbProfile)this.restTemplate.getForObject(this.buildUrl("user/other_info", (MultiValueMap<String, String>)params), TxwbProfile.class);
    }

    @Override
    public void update(String nick, int sex, int year, int month, int day, String countrycode, String provincecode, String citycode, String introduction) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"nick", (Object)nick);
        params.add((Object)"sex", (Object)String.valueOf(sex));
        params.add((Object)"year", (Object)String.valueOf(year));
        params.add((Object)"month", (Object)String.valueOf(month));
        params.add((Object)"day", (Object)String.valueOf(day));
        params.add((Object)"countrycode", (Object)countrycode);
        params.add((Object)"provincecode", (Object)provincecode);
        params.add((Object)"citycode", (Object)citycode);
        params.add((Object)"introduction", (Object)introduction);
        this.restTemplate.postForLocation(this.buildUrl("user/update"), (Object)params);
    }

    @Override
    public void addFollowing(String ... names) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)StringUtils.arrayToCommaDelimitedString((Object[])names));
        this.restTemplate.postForLocation(this.buildUrl("friends/add"), (Object)params);
    }

    @Override
    public void delFollowing(String name) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        this.restTemplate.postForLocation(this.buildUrl("friends/del"), (Object)params);
    }

    @Override
    public void addSpecial(String name) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        this.restTemplate.postForLocation(this.buildUrl("friends/addspecial"), (Object)params);
    }

    @Override
    public void delSpecial(String name) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        this.restTemplate.postForLocation(this.buildUrl("friends/delspecial"), (Object)params);
    }

    @Override
    public void addBlackList(String name) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        this.restTemplate.postForLocation(this.buildUrl("friends/addblacklist"), (Object)params);
    }

    @Override
    public void delBlackList(String name) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        this.restTemplate.postForLocation(this.buildUrl("friends/delblacklist"), (Object)params);
    }

    @Override
    public List<TxwbProfile> getFollowers(int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/fanslist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getFollowers(String name, int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/user_fanslist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getFollowerNames(int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/fanslist_name", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getFollowing(int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/idollist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getFollowing(String name, int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/user_idollist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getFollowingNames(int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/idollist_name", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getBlackList(int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/blacklist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getSpecialList(int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/speciallist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }

    @Override
    public List<TxwbProfile> getSpecialList(String name, int reqnum, int startindex) {
        this.isAuthorized();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"name", (Object)name);
        params.add((Object)"reqnum", (Object)String.valueOf(reqnum));
        params.add((Object)"startindex", (Object)String.valueOf(startindex));
        return ((TxwbProfileList)this.restTemplate.getForObject(this.buildUrl("friends/user_speciallist", (MultiValueMap<String, String>)params), TxwbProfileList.class)).getInfo();
    }
}

