/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.network.netty;

import eu.stratosphere.runtime.io.Buffer;
import eu.stratosphere.runtime.io.network.Envelope;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;

@ChannelHandler.Sharable
public class OutboundEnvelopeEncoder
extends ChannelOutboundHandlerAdapter {
    public static final int HEADER_SIZE = 48;
    public static final int MAGIC_NUMBER = -1159983106;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Envelope env = (Envelope)msg;
        ByteBuf buf = ctx.alloc().directBuffer();
        this.encode(env, buf);
        if (buf.isReadable()) {
            ctx.write((Object)buf, promise);
        } else {
            buf.release();
            ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
        }
    }

    private void encode(Envelope env, ByteBuf out) {
        out.writeInt(-1159983106);
        if (out.getInt(out.writerIndex() - 4) != -1159983106) {
            throw new RuntimeException();
        }
        out.writeInt(env.getSequenceNumber());
        env.getJobID().writeTo(out);
        env.getSource().writeTo(out);
        out.writeInt(env.getEventsSerialized() != null ? env.getEventsSerialized().remaining() : 0);
        out.writeInt(env.getBuffer() != null ? env.getBuffer().size() : 0);
        if (env.getEventsSerialized() != null) {
            out.writeBytes(env.getEventsSerialized());
        }
        if (env.getBuffer() != null) {
            Buffer envBuffer = env.getBuffer();
            out.writeBytes(envBuffer.getMemorySegment().wrap(0, envBuffer.size()));
            envBuffer.recycleBuffer();
        }
    }
}

