/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.network.bufferprovider;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.runtime.io.Buffer;
import eu.stratosphere.runtime.io.BufferRecycler;
import eu.stratosphere.runtime.io.network.bufferprovider.BufferAvailabilityListener;
import eu.stratosphere.runtime.io.network.bufferprovider.BufferProvider;
import eu.stratosphere.runtime.io.network.bufferprovider.GlobalBufferPool;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;

public final class LocalBufferPool
implements BufferProvider {
    private static final int WAIT_TIME = 100;
    private final GlobalBufferPool globalBufferPool;
    private final Queue<MemorySegment> buffers = new ArrayDeque<MemorySegment>();
    private final LocalBufferPoolRecycler recycler;
    private final Queue<BufferAvailabilityListener> listeners = new ArrayDeque<BufferAvailabilityListener>();
    private final int bufferSize;
    private int numDesignatedBuffers;
    private int numRequestedBuffers;
    private boolean hasAsyncEventOccurred;
    private boolean isDestroyed;

    public LocalBufferPool(GlobalBufferPool globalBufferPool, int numDesignatedBuffers) {
        this.globalBufferPool = globalBufferPool;
        this.bufferSize = globalBufferPool.getBufferSize();
        this.numDesignatedBuffers = numDesignatedBuffers;
        this.recycler = new LocalBufferPoolRecycler(this);
    }

    @Override
    public Buffer requestBuffer(int minBufferSize) throws IOException {
        try {
            return this.requestBuffer(minBufferSize, false);
        }
        catch (InterruptedException e) {
            throw new IOException("Unexpected InterruptedException while non-blocking buffer request.");
        }
    }

    @Override
    public Buffer requestBufferBlocking(int minBufferSize) throws IOException, InterruptedException {
        return this.requestBuffer(minBufferSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer requestBuffer(int minBufferSize, boolean isBlocking) throws IOException, InterruptedException {
        if (minBufferSize > this.bufferSize) {
            throw new IllegalArgumentException(String.format("Too large buffer requested (requested %d, maximum %d).", minBufferSize, this.bufferSize));
        }
        while (true) {
            boolean isAsyncRequest = false;
            Queue<MemorySegment> queue = this.buffers;
            synchronized (queue) {
                MemorySegment buffer;
                while (this.numRequestedBuffers > this.numDesignatedBuffers && (buffer = this.buffers.poll()) != null) {
                    this.globalBufferPool.returnBuffer(buffer);
                    --this.numRequestedBuffers;
                }
                while (this.buffers.isEmpty()) {
                    if (this.numRequestedBuffers < this.numDesignatedBuffers && (buffer = this.globalBufferPool.requestBuffer()) != null) {
                        this.buffers.add(buffer);
                        ++this.numRequestedBuffers;
                        continue;
                    }
                    if (this.hasAsyncEventOccurred && isBlocking) {
                        this.hasAsyncEventOccurred = false;
                        isAsyncRequest = true;
                        break;
                    }
                    if (isBlocking) {
                        this.buffers.wait(100L);
                        continue;
                    }
                    return null;
                }
                if (!isAsyncRequest) {
                    return new Buffer(this.buffers.poll(), minBufferSize, this.recycler);
                }
            }
        }
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportAsynchronousEvent() {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            this.hasAsyncEventOccurred = true;
            this.buffers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferProvider.BufferAvailabilityRegistration registerBufferAvailabilityListener(BufferAvailabilityListener listener) {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            if (!this.buffers.isEmpty()) {
                return BufferProvider.BufferAvailabilityRegistration.FAILED_BUFFER_AVAILABLE;
            }
            if (this.isDestroyed) {
                return BufferProvider.BufferAvailabilityRegistration.FAILED_BUFFER_POOL_DESTROYED;
            }
            this.listeners.add(listener);
        }
        return BufferProvider.BufferAvailabilityRegistration.SUCCEEDED_REGISTERED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumDesignatedBuffers(int numDesignatedBuffers) {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            this.numDesignatedBuffers = numDesignatedBuffers;
            while (this.numRequestedBuffers > this.numDesignatedBuffers && !this.buffers.isEmpty()) {
                this.globalBufferPool.returnBuffer(this.buffers.poll());
                --this.numRequestedBuffers;
            }
            this.buffers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numAvailableBuffers() {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            return this.buffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numRequestedBuffers() {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            return this.numRequestedBuffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numDesignatedBuffers() {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            return this.numDesignatedBuffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
            while (!this.buffers.isEmpty()) {
                this.globalBufferPool.returnBuffer(this.buffers.poll());
                --this.numRequestedBuffers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleBuffer(MemorySegment buffer) {
        Queue<MemorySegment> queue = this.buffers;
        synchronized (queue) {
            if (this.isDestroyed) {
                this.globalBufferPool.returnBuffer(buffer);
                --this.numRequestedBuffers;
            } else if (this.numRequestedBuffers > this.numDesignatedBuffers) {
                this.globalBufferPool.returnBuffer(buffer);
                --this.numRequestedBuffers;
            } else if (!this.listeners.isEmpty()) {
                Buffer availableBuffer = new Buffer(buffer, buffer.size(), this.recycler);
                try {
                    this.listeners.poll().bufferAvailable(availableBuffer);
                }
                catch (Exception e) {
                    this.buffers.add(buffer);
                    this.buffers.notify();
                }
            } else {
                this.buffers.add(buffer);
                this.buffers.notify();
            }
        }
    }

    private static final class LocalBufferPoolRecycler
    implements BufferRecycler {
        private final LocalBufferPool bufferPool;

        private LocalBufferPoolRecycler(LocalBufferPool bufferPool) {
            this.bufferPool = bufferPool;
        }

        @Override
        public void recycle(MemorySegment buffer) {
            this.bufferPool.recycleBuffer(buffer);
        }
    }
}

