/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.network;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.runtime.io.channels.ChannelID;
import eu.stratosphere.runtime.io.network.RemoteReceiver;
import java.io.IOException;

public class ConnectionInfoLookupResponse
implements IOReadableWritable {
    private ReturnCode returnCode;
    private RemoteReceiver remoteTarget;
    private ChannelID localTarget;

    public ConnectionInfoLookupResponse() {
    }

    public ConnectionInfoLookupResponse(ReturnCode code) {
        this.returnCode = code;
        this.remoteTarget = null;
        this.localTarget = null;
    }

    public ConnectionInfoLookupResponse(ReturnCode code, ChannelID localTarget) {
        this.returnCode = code;
        this.remoteTarget = null;
        this.localTarget = localTarget;
    }

    public ConnectionInfoLookupResponse(ReturnCode code, RemoteReceiver receiver) {
        this.returnCode = code;
        this.remoteTarget = receiver;
        this.localTarget = null;
    }

    public RemoteReceiver getRemoteTarget() {
        return this.remoteTarget;
    }

    public ChannelID getLocalTarget() {
        return this.localTarget;
    }

    public void read(DataInputView in) throws IOException {
        this.returnCode = ReturnCode.values()[in.readInt()];
        if (in.readBoolean()) {
            this.remoteTarget = new RemoteReceiver();
            this.remoteTarget.read(in);
        }
        if (in.readBoolean()) {
            this.localTarget = new ChannelID();
            this.localTarget.read(in);
        }
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.returnCode.ordinal());
        if (this.remoteTarget != null) {
            out.writeBoolean(true);
            this.remoteTarget.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.localTarget != null) {
            out.writeBoolean(true);
            this.localTarget.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean receiverNotFound() {
        return this.returnCode == ReturnCode.NOT_FOUND;
    }

    public boolean receiverNotReady() {
        return this.returnCode == ReturnCode.FOUND_BUT_RECEIVER_NOT_READY;
    }

    public boolean receiverReady() {
        return this.returnCode == ReturnCode.FOUND_AND_RECEIVER_READY;
    }

    public boolean isJobAborting() {
        return this.returnCode == ReturnCode.JOB_IS_ABORTING;
    }

    public static ConnectionInfoLookupResponse createReceiverFoundAndReady(ChannelID targetChannelID) {
        return new ConnectionInfoLookupResponse(ReturnCode.FOUND_AND_RECEIVER_READY, targetChannelID);
    }

    public static ConnectionInfoLookupResponse createReceiverFoundAndReady(RemoteReceiver remoteReceiver) {
        return new ConnectionInfoLookupResponse(ReturnCode.FOUND_AND_RECEIVER_READY, remoteReceiver);
    }

    public static ConnectionInfoLookupResponse createReceiverNotFound() {
        return new ConnectionInfoLookupResponse(ReturnCode.NOT_FOUND);
    }

    public static ConnectionInfoLookupResponse createReceiverNotReady() {
        return new ConnectionInfoLookupResponse(ReturnCode.FOUND_BUT_RECEIVER_NOT_READY);
    }

    public static ConnectionInfoLookupResponse createJobIsAborting() {
        return new ConnectionInfoLookupResponse(ReturnCode.JOB_IS_ABORTING);
    }

    public String toString() {
        return this.returnCode.name() + ", local target: " + this.localTarget + ", remoteTarget: " + this.remoteTarget;
    }

    private static enum ReturnCode {
        NOT_FOUND,
        FOUND_AND_RECEIVER_READY,
        FOUND_BUT_RECEIVER_NOT_READY,
        JOB_IS_ABORTING;

    }
}

