/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.gates;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.nephele.deployment.ChannelDeploymentDescriptor;
import eu.stratosphere.nephele.deployment.GateDeploymentDescriptor;
import eu.stratosphere.nephele.event.task.AbstractEvent;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.runtime.io.Buffer;
import eu.stratosphere.runtime.io.channels.ChannelID;
import eu.stratosphere.runtime.io.channels.OutputChannel;
import eu.stratosphere.runtime.io.gates.Gate;
import eu.stratosphere.runtime.io.gates.GateID;
import java.io.IOException;

public class OutputGate
extends Gate<IOReadableWritable> {
    private OutputChannel[] channels;
    private boolean closed;

    public OutputGate(JobID jobId, GateID gateId, int index) {
        super(jobId, gateId, index);
    }

    public void sendBuffer(Buffer buffer, int targetChannel) throws IOException, InterruptedException {
        this.channels[targetChannel].sendBuffer(buffer);
    }

    public void sendEvent(AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.channels[targetChannel].sendEvent(event);
    }

    public void sendBufferAndEvent(Buffer buffer, AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.channels[targetChannel].sendBufferAndEvent(buffer, event);
    }

    public void broadcastBuffer(Buffer buffer) throws IOException, InterruptedException {
        for (int i = 1; i < this.channels.length; ++i) {
            this.channels[i].sendBuffer(buffer.duplicate());
        }
        this.channels[0].sendBuffer(buffer);
    }

    public void broadcastEvent(AbstractEvent event) throws IOException, InterruptedException {
        for (OutputChannel channel : this.channels) {
            channel.sendEvent(event);
        }
    }

    public void initializeChannels(GateDeploymentDescriptor descriptor) {
        int numChannels = descriptor.getNumberOfChannelDescriptors();
        this.channels = new OutputChannel[numChannels];
        this.setChannelType(descriptor.getChannelType());
        for (int i = 0; i < numChannels; ++i) {
            ChannelDeploymentDescriptor channelDescriptor = descriptor.getChannelDescriptor(i);
            ChannelID id = channelDescriptor.getOutputChannelID();
            ChannelID connectedId = channelDescriptor.getInputChannelID();
            this.channels[i] = new OutputChannel(this, i, id, connectedId, this.getChannelType());
        }
    }

    public OutputChannel[] channels() {
        return this.channels;
    }

    public OutputChannel getChannel(int index) {
        return index < this.channels.length ? this.channels[index] : null;
    }

    public int getNumChannels() {
        return this.channels.length;
    }

    public void requestClose() throws IOException, InterruptedException {
        for (OutputChannel channel : this.channels) {
            channel.requestClose();
        }
    }

    @Override
    public boolean isClosed() {
        if (this.closed) {
            return true;
        }
        for (OutputChannel channel : this.channels) {
            if (channel.isClosed()) continue;
            return false;
        }
        this.closed = true;
        return true;
    }

    public void waitForGateToBeClosed() throws InterruptedException {
        if (this.closed) {
            return;
        }
        for (OutputChannel channel : this.channels) {
            channel.waitForChannelToBeClosed();
        }
        this.closed = true;
    }

    @Override
    public boolean isInputGate() {
        return false;
    }

    @Override
    public String toString() {
        return "Output " + super.toString();
    }

    @Override
    public void publishEvent(AbstractEvent event) throws IOException, InterruptedException {
    }

    @Override
    public void releaseAllChannelResources() {
    }
}

