/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.gates;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.nephele.event.task.AbstractEvent;
import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.nephele.event.task.EventListener;
import eu.stratosphere.nephele.event.task.EventNotificationManager;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.runtime.io.channels.ChannelType;
import eu.stratosphere.runtime.io.gates.GateID;
import java.io.IOException;

public abstract class Gate<T extends IOReadableWritable> {
    private final JobID jobID;
    private final GateID gateID;
    private final int index;
    private final EventNotificationManager eventNotificationManager = new EventNotificationManager();
    private ChannelType channelType = ChannelType.NETWORK;

    protected Gate(JobID jobID, GateID gateID, int index) {
        this.jobID = jobID;
        this.gateID = gateID;
        this.index = index;
    }

    public final int getIndex() {
        return this.index;
    }

    protected final EventNotificationManager getEventNotificationManager() {
        return this.eventNotificationManager;
    }

    public String toString() {
        return "Gate " + this.index;
    }

    public final void subscribeToEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.eventNotificationManager.subscribeToEvent(eventListener, eventType);
    }

    public final void unsubscribeFromEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.eventNotificationManager.unsubscribeFromEvent(eventListener, eventType);
    }

    public final void deliverEvent(AbstractTaskEvent event) {
        this.eventNotificationManager.deliverEvent(event);
    }

    public final void setChannelType(ChannelType channelType) {
        this.channelType = channelType;
    }

    public final ChannelType getChannelType() {
        return this.channelType;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public GateID getGateID() {
        return this.gateID;
    }

    public abstract void publishEvent(AbstractEvent var1) throws IOException, InterruptedException;

    public abstract void releaseAllChannelResources();

    public abstract boolean isClosed() throws IOException, InterruptedException;

    public abstract boolean isInputGate();
}

