/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.channels;

import eu.stratosphere.nephele.event.task.AbstractEvent;
import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.runtime.io.Buffer;
import eu.stratosphere.runtime.io.channels.Channel;
import eu.stratosphere.runtime.io.channels.ChannelCloseEvent;
import eu.stratosphere.runtime.io.channels.ChannelID;
import eu.stratosphere.runtime.io.channels.ChannelType;
import eu.stratosphere.runtime.io.channels.ReceiverAlreadyClosedException;
import eu.stratosphere.runtime.io.gates.OutputGate;
import eu.stratosphere.runtime.io.network.Envelope;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputChannel
extends Channel {
    private static final Log LOG = LogFactory.getLog(OutputChannel.class);
    private final Object closeLock = new Object();
    private final OutputGate outputGate;
    private boolean senderCloseRequested;
    private boolean receiverCloseRequested;
    private int currentSeqNum;

    public OutputChannel(OutputGate outputGate, int index, ChannelID id, ChannelID connectedId, ChannelType type) {
        super(index, id, connectedId, type);
        this.outputGate = outputGate;
    }

    public void sendBuffer(Buffer buffer) throws IOException, InterruptedException {
        this.checkStatus();
        if (buffer.size() == 0) {
            buffer.recycleBuffer();
            return;
        }
        Envelope envelope = this.createNextEnvelope();
        envelope.setBuffer(buffer);
        this.envelopeDispatcher.dispatchFromOutputChannel(envelope);
    }

    public void sendEvent(AbstractEvent event) throws IOException, InterruptedException {
        this.checkStatus();
        Envelope envelope = this.createNextEnvelope();
        envelope.serializeEventList(Arrays.asList(event));
        this.envelopeDispatcher.dispatchFromOutputChannel(envelope);
    }

    public void sendBufferAndEvent(Buffer buffer, AbstractEvent event) throws IOException, InterruptedException {
        this.checkStatus();
        Envelope envelope = this.createNextEnvelope();
        envelope.setBuffer(buffer);
        envelope.serializeEventList(Arrays.asList(event));
        this.envelopeDispatcher.dispatchFromOutputChannel(envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueEnvelope(Envelope envelope) {
        if (envelope.hasBuffer()) {
            throw new IllegalStateException("Envelope for OutputChannel has Buffer attached.");
        }
        for (AbstractEvent abstractEvent : envelope.deserializeEvents()) {
            if (abstractEvent.getClass() == ChannelCloseEvent.class) {
                Object object = this.closeLock;
                synchronized (object) {
                    this.receiverCloseRequested = true;
                    this.closeLock.notifyAll();
                    continue;
                }
            }
            if (abstractEvent instanceof AbstractTaskEvent) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OutputChannel received task event: " + abstractEvent));
                }
                this.outputGate.deliverEvent((AbstractTaskEvent)abstractEvent);
                continue;
            }
            throw new RuntimeException("OutputChannel received an event that is neither close nor task event.");
        }
    }

    public void requestClose() throws IOException, InterruptedException {
        if (this.senderCloseRequested) {
            return;
        }
        this.senderCloseRequested = true;
        Envelope envelope = this.createNextEnvelope();
        envelope.serializeEventList(Arrays.asList(new ChannelCloseEvent()));
        this.envelopeDispatcher.dispatchFromOutputChannel(envelope);
    }

    @Override
    public boolean isClosed() {
        return this.senderCloseRequested && this.receiverCloseRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForChannelToBeClosed() throws InterruptedException {
        Object object = this.closeLock;
        synchronized (object) {
            while (!this.receiverCloseRequested) {
                this.closeLock.wait(1000L);
            }
        }
    }

    @Override
    public boolean isInputChannel() {
        return false;
    }

    @Override
    public JobID getJobID() {
        return this.outputGate.getJobID();
    }

    private void checkStatus() throws IOException {
        if (this.senderCloseRequested) {
            throw new IllegalStateException(String.format("Channel %s already requested to be closed", this.getID()));
        }
        if (this.receiverCloseRequested) {
            throw new ReceiverAlreadyClosedException();
        }
    }

    private Envelope createNextEnvelope() {
        return new Envelope(this.currentSeqNum++, this.getJobID(), this.getID());
    }

    @Override
    public void transferEvent(AbstractEvent event) throws IOException, InterruptedException {
    }

    @Override
    public void releaseAllResources() {
    }

    @Override
    public void destroy() {
    }
}

